/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.builder;

import co.aurasphere.botmill.kik.model.BaseBuilder;
import co.aurasphere.botmill.kik.model.Buildable;
import co.aurasphere.botmill.kik.model.Keyboard;
import co.aurasphere.botmill.kik.model.MessageType;
import co.aurasphere.botmill.kik.outgoing.model.TextMessage;

public class TextMessageBuilder
extends BaseBuilder
implements Buildable<TextMessage> {
    private static TextMessage textMessage;
    private static TextMessageBuilder instance;

    public static TextMessageBuilder getInstance() {
        if (instance == null) {
            instance = new TextMessageBuilder();
        }
        textMessage = new TextMessage();
        textMessage.setType(MessageType.TEXT);
        return instance;
    }

    public TextMessageBuilder() {
        textMessage = new TextMessage();
        textMessage.setType(MessageType.TEXT);
    }

    public TextMessageBuilder setTo(String to) {
        textMessage.setTo(to);
        return this;
    }

    public TextMessageBuilder setBody(String body) {
        textMessage.setBody(body);
        return this;
    }

    public TextMessageBuilder setDelay(Integer delay) {
        textMessage.setDelay(delay);
        return this;
    }

    public TextMessageBuilder setTimeType(Integer typeTime) {
        textMessage.setTypeTime(String.valueOf(typeTime));
        return this;
    }

    public TextMessageBuilder addKeyboard(Keyboard keyboard) {
        textMessage.addKeyboard(keyboard);
        return this;
    }

    @Override
    public TextMessage build() {
        return textMessage;
    }
}

