/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.builder;

import co.aurasphere.botmill.kik.KikBotMillContext;
import co.aurasphere.botmill.kik.model.ActionFrame;
import co.aurasphere.botmill.kik.model.Buildable;
import co.aurasphere.botmill.kik.model.Command;
import co.aurasphere.botmill.kik.model.Event;
import co.aurasphere.botmill.kik.model.Message;
import co.aurasphere.botmill.kik.model.Reply;
import java.util.List;

public class ActionFrameBuilder
implements Buildable<ActionFrame> {
    private static ActionFrame actionFrame = new ActionFrame();
    private static ActionFrameBuilder instance;

    private ActionFrameBuilder() {
    }

    public static ActionFrameBuilder getInstance() {
        if (instance == null) {
            instance = new ActionFrameBuilder();
        }
        actionFrame = new ActionFrame();
        return instance;
    }

    public ActionFrameBuilder setEvent(Event event) {
        actionFrame.setEvent(event);
        return this;
    }

    public ActionFrameBuilder addReply(Reply reply) {
        actionFrame.addReply(reply);
        return this;
    }

    public ActionFrameBuilder addReplies(List<Reply<? extends Message>> replies) {
        actionFrame.addReplies(replies);
        return this;
    }

    public ActionFrameBuilder addReplies(Reply<? extends Message> ... replies) {
        actionFrame.addReplies(replies);
        return this;
    }

    public ActionFrameBuilder addPreCommand(Command command) {
        actionFrame.addPreCommand(command);
        return this;
    }

    public ActionFrameBuilder addPostCommand(Command command) {
        actionFrame.addPostCommand(command);
        return this;
    }

    public ActionFrame buildToContext() {
        KikBotMillContext.getInstance().addActionFrameToContext(actionFrame);
        return actionFrame;
    }

    public ActionFrame buildToBroadcast() {
        KikBotMillContext.getInstance().addActionFrameToBroadcast(actionFrame);
        return actionFrame;
    }

    public ActionFrame buildToContextAndBroadcast() {
        KikBotMillContext.getInstance().addActionFrameToContext(actionFrame);
        KikBotMillContext.getInstance().addActionFrameToBroadcast(actionFrame);
        return actionFrame;
    }

    @Override
    public ActionFrame build() {
        return actionFrame;
    }
}

