/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik;

import co.aurasphere.botmill.kik.KikBotMillEntry;
import co.aurasphere.botmill.kik.KikBotMillLoader;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KikBotMillServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(KikBotMillServlet.class);

    public void init() throws ServletException {
        String botDefinitionClass = this.getServletConfig().getInitParameter("bot-definition-class");
        if (botDefinitionClass == null || botDefinitionClass.isEmpty()) {
            logger.error("Bot definition class not found in web.xml. Make sure to add the fully qualified name of the a class implementing co.aurasphere.botmill.fb.KikBotDefinition as an init-param of the FbBotMillServlet.");
            throw new ServletException("Bot definition class not found in web.xml. Make sure to add the fully qualified name of the a class implementing co.aurasphere.botmill.fb.KikBotDefinition as an init-param of the FbBotMillServlet.");
        }
        KikBotMillEntry botEntry = null;
        try {
            botEntry = (KikBotMillEntry)((Object)((Object)this)).getClass().getClassLoader().loadClass(botDefinitionClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.error("Error while loading KikBotDefinition class [ " + botDefinitionClass + " ]", (Throwable)e);
            throw new ServletException("Error while loading KikBotDefinition class [ " + botDefinitionClass + " ]", (Throwable)e);
        }
        catch (ClassCastException e) {
            logger.error("Class [ " + botDefinitionClass + " ] does not implement co.aurasphere.botmill.kik.KikBotDefinition", (Throwable)e);
            throw new ServletException("Class [ " + botDefinitionClass + " ] does not implement co.aurasphere.botmill.kik.KikBotDefinition", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Error during instantiation of class [ " + botDefinitionClass + " ]", (Throwable)e);
            throw new ServletException("Error during instantiation of class [ " + botDefinitionClass + " ]", (Throwable)e);
        }
        botEntry.kikBotEntry();
        logger.info("KikBotMillServlet configuration OK.");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        KikBotMillLoader.getLoader().postHandler(req, resp);
    }

    public String toString() {
        return "KikBotMillServlet []";
    }
}

