/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik;

import co.aurasphere.botmill.kik.KikBotMillEntry;
import co.aurasphere.botmill.kik.incoming.handler.IncomingToOutgoingMessageHandler;
import co.aurasphere.botmill.kik.json.JsonUtils;
import co.aurasphere.botmill.kik.model.Message;
import co.aurasphere.botmill.kik.model.MessageCallback;
import java.io.IOException;
import java.io.Reader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KikBotMillLoader {
    private static KikBotMillLoader instance;
    private static final Logger logger;

    public static KikBotMillLoader getLoader() {
        if (instance == null) {
            instance = new KikBotMillLoader();
        }
        return instance;
    }

    public KikBotMillLoader loadEntryPoint(KikBotMillEntry entry) {
        entry.kikBotEntry();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBroadcast(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String json = KikBotMillLoader.readerToString(req.getReader());
            logger.debug("BROADCAST - JSON INPUT: " + json);
            MessageCallback messages = JsonUtils.fromJson(json, MessageCallback.class);
            for (Message message : messages.getMessages()) {
                IncomingToOutgoingMessageHandler.createHandler().processBroadcast(message);
            }
        }
        catch (Exception e) {
            logger.error("Error during MessengerCallback parsing: ", (Throwable)e);
            return;
        }
        finally {
            resp.setStatus(200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postHandler(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String json = KikBotMillLoader.readerToString(req.getReader());
            logger.debug("JSON INPUT: " + json);
            MessageCallback messages = JsonUtils.fromJson(json, MessageCallback.class);
            for (Message message : messages.getMessages()) {
                IncomingToOutgoingMessageHandler.createHandler().process(message);
                IncomingToOutgoingMessageHandler.createHandler().processBroadcast(message);
            }
        }
        catch (Exception e) {
            logger.error("Error during MessengerCallback parsing: ", (Throwable)e);
            return;
        }
        finally {
            resp.setStatus(200);
        }
    }

    private static String readerToString(Reader reader) throws IOException {
        int numCharsRead;
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numCharsRead);
        }
        return buffer.toString();
    }

    static {
        logger = LoggerFactory.getLogger(KikBotMillLoader.class);
    }
}

