/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik;

import co.aurasphere.botmill.kik.KikBotMillEntry;
import co.aurasphere.botmill.kik.configuration.Authentication;
import co.aurasphere.botmill.kik.incoming.event.AnyEvent;
import co.aurasphere.botmill.kik.model.Domain;
import co.aurasphere.botmill.kik.model.Frame;
import java.util.ArrayList;
import java.util.List;

public class KikBotMillContext {
    private static KikBotMillContext instance;
    private Authentication authentication;
    private String webhookUrl;
    private List<KikBotMillEntry> entryPoints = new ArrayList<KikBotMillEntry>();
    private List<Domain> domains = new ArrayList<Domain>();
    private List<Frame> actionFrames = new ArrayList<Frame>();
    private List<Frame> anyEventActionFrames = new ArrayList<Frame>();
    private List<Frame> broadcastActionFrames = new ArrayList<Frame>();

    public static KikBotMillContext getInstance() {
        if (instance == null) {
            instance = new KikBotMillContext();
        }
        return instance;
    }

    public List<Domain> getDomains() {
        return this.domains;
    }

    public List<Frame> getActionFrames() {
        return this.actionFrames;
    }

    public List<Frame> getAnyEventActionFrames() {
        return this.anyEventActionFrames;
    }

    public List<Frame> getBroadcastMessageActionFrames() {
        return this.broadcastActionFrames;
    }

    public String getUser() {
        return this.authentication.getUser();
    }

    public String getApiKey() {
        return this.authentication.getApiKey();
    }

    public void setup(String username, String apiKey) {
        this.authentication = new Authentication();
        this.authentication.setUser(username);
        this.authentication.setApiKey(apiKey);
    }

    public void registerEntryPoint(KikBotMillEntry kikBotMillEntry) {
        this.entryPoints.add(kikBotMillEntry);
    }

    public void setWebHookUrl(String url) {
        this.webhookUrl = url;
    }

    public String getWebHookUrl() {
        return this.webhookUrl;
    }

    public void registerDomain(Domain domain) {
        this.domains.add(domain);
    }

    public void registerAnnotatedDomain(Domain domain) {
    }

    public void addActionFrameToContext(Frame actionFrame) {
        if (actionFrame.getEvent() instanceof AnyEvent) {
            this.anyEventActionFrames.add(actionFrame);
        } else {
            this.actionFrames.add(actionFrame);
        }
    }

    public void addActionFramesToContext(List<Frame> frames) {
        for (Frame actionFrame : frames) {
            if (actionFrame.getEvent() instanceof AnyEvent) {
                this.anyEventActionFrames.add(actionFrame);
                continue;
            }
            this.actionFrames.add(actionFrame);
        }
    }

    public void addActionFrameToBroadcast(Frame actionFrame) {
        this.broadcastActionFrames.add(actionFrame);
    }
}

