/**
 * 
 * MIT License
 *
 * Copyright (c) 2017 BotMill.io
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 */
package co.aurasphere.botmill.kik.incoming.event;

import co.aurasphere.botmill.kik.incoming.model.IncomingMessage;
import co.aurasphere.botmill.kik.incoming.model.PictureMessage;
import co.aurasphere.botmill.kik.model.Event;
import co.aurasphere.botmill.kik.model.MessageType;

/**
 * The Class PictureMessageEvent.
 * 
 * @author Alvin P. Reyes
 */
public class PictureMessageEvent implements Event {
	
	/** The incoming picture message. */
	private PictureMessage incomingPictureMessage = null;
	
	/**
	 * Instantiates a new picture message event.
	 */
	public PictureMessageEvent() {}
	
	/**
	 * Instantiates a new picture message event.
	 *
	 * @param incomingPictureMessage the incoming picture message
	 */
	public PictureMessageEvent(PictureMessage incomingPictureMessage) {
		this.incomingPictureMessage = incomingPictureMessage;
	}
	
	/* (non-Javadoc)
	 * @see co.aurasphere.botmill.kik.intf.Event#verifyEvent(co.aurasphere.botmill.kik.incoming.model.IncomingMessage)
	 */
	@Override
	public boolean verifyEvent(IncomingMessage incomingMessage) {
		if (incomingMessage instanceof PictureMessage) {
			if(this.incomingPictureMessage != null) {
				if(((PictureMessage) incomingMessage).compareTo(this.incomingPictureMessage) == 0) {
					return true;
				}else {
					return false;
				}
			}
			if (((PictureMessage) incomingMessage).getType().equals(MessageType.PICTURE)) {
				return true;
			}
		}
		return false;
	}
}
