/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.json;

import co.aurasphere.botmill.kik.incoming.model.FriendPickerMessage;
import co.aurasphere.botmill.kik.incoming.model.IsTypingMessage;
import co.aurasphere.botmill.kik.incoming.model.LinkMessage;
import co.aurasphere.botmill.kik.incoming.model.PictureMessage;
import co.aurasphere.botmill.kik.incoming.model.ScanDataMessage;
import co.aurasphere.botmill.kik.incoming.model.StickerMessage;
import co.aurasphere.botmill.kik.incoming.model.TextMessage;
import co.aurasphere.botmill.kik.incoming.model.VideoMessage;
import co.aurasphere.botmill.kik.json.SkipDeserializationAnnotationExclusionStrategy;
import co.aurasphere.botmill.kik.model.Message;
import co.aurasphere.botmill.kik.model.MessageCallback;
import co.aurasphere.botmill.kik.model.MessageType;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class IncomingMessagesDeserializer
implements JsonDeserializer<MessageCallback> {
    private static Gson delegateGson;

    public IncomingMessagesDeserializer() {
        GsonBuilder builder = new GsonBuilder();
        builder.addDeserializationExclusionStrategy((ExclusionStrategy)new SkipDeserializationAnnotationExclusionStrategy());
        delegateGson = builder.create();
    }

    public MessageCallback deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        MessageCallback messageCallback = new MessageCallback();
        JsonElement jsonMessages = json.getAsJsonObject().get("messages");
        for (int i = 0; i < jsonMessages.getAsJsonArray().size(); ++i) {
            JsonObject jsonMessage = jsonMessages.getAsJsonArray().get(i).getAsJsonObject();
            String typeString = jsonMessage.get("type").getAsString();
            MessageType messageType = MessageType.valueOf(typeString.replace('-', '_').toUpperCase());
            Class messageClass = null;
            switch (messageType) {
                case TEXT: {
                    messageClass = TextMessage.class;
                    break;
                }
                case PICTURE: {
                    messageClass = PictureMessage.class;
                    break;
                }
                case VIDEO: {
                    messageClass = VideoMessage.class;
                    break;
                }
                case LINK: {
                    messageClass = LinkMessage.class;
                    break;
                }
                case SCAN_DATA: {
                    messageClass = ScanDataMessage.class;
                    break;
                }
                case STICKER: {
                    messageClass = StickerMessage.class;
                    break;
                }
                case FRIEND_PICKER: {
                    messageClass = FriendPickerMessage.class;
                    break;
                }
                case IS_TYPING: {
                    messageClass = IsTypingMessage.class;
                }
            }
            Message message = (Message)context.deserialize((JsonElement)jsonMessage, messageClass);
            messageCallback.addMessage(message);
        }
        return messageCallback;
    }

    public String toString() {
        return "IncomingMessagesDeserializer []";
    }
}

