/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.incoming.handler;

import co.aurasphere.botmill.kik.builder.ActionFrameBuilder;
import co.aurasphere.botmill.kik.builder.LinkMessageBuilder;
import co.aurasphere.botmill.kik.builder.PictureMessageBuilder;
import co.aurasphere.botmill.kik.builder.VideoMessageBuilder;
import co.aurasphere.botmill.kik.factory.EventFactory;
import co.aurasphere.botmill.kik.factory.ReplyFactory;
import co.aurasphere.botmill.kik.incoming.handler.model.JsonAction;
import co.aurasphere.botmill.kik.incoming.handler.model.JsonReply;
import co.aurasphere.botmill.kik.incoming.handler.model.JsonToActionFrame;
import co.aurasphere.botmill.kik.json.JsonUtils;
import co.aurasphere.botmill.kik.model.Frame;
import co.aurasphere.botmill.kik.model.Message;
import co.aurasphere.botmill.kik.model.Reply;
import co.aurasphere.botmill.kik.network.NetworkUtils;
import co.aurasphere.botmill.kik.outgoing.model.LinkMessage;
import co.aurasphere.botmill.kik.outgoing.model.PictureMessage;
import co.aurasphere.botmill.kik.outgoing.model.VideoMessage;
import co.aurasphere.botmill.kik.outgoing.reply.LinkMessageReply;
import co.aurasphere.botmill.kik.outgoing.reply.PictureMessageReply;
import co.aurasphere.botmill.kik.outgoing.reply.VideoMessageReply;
import java.util.ArrayList;
import java.util.List;

public class JsonToActionFrameHandler {
    private static final String CONST_TEXT = "text";
    private static final String CONST_PATTERN = "pattern";

    public static List<Frame> jsonToFrameReply(String jsonUrl) {
        ArrayList<Frame> list = new ArrayList<Frame>();
        String json = NetworkUtils.get(jsonUrl);
        JsonToActionFrame a = JsonUtils.fromJson(json, JsonToActionFrame.class);
        for (JsonAction jaction : a.getJsonTextAction()) {
            if (jaction.getEvent().equals(CONST_PATTERN)) {
                list.add(ActionFrameBuilder.getInstance().setEvent(EventFactory.textMessagePattern(jaction.getInput())).addReplies(JsonToActionFrameHandler.processReplies(jaction)).build());
                continue;
            }
            if (!jaction.getEvent().equals(CONST_TEXT)) continue;
            list.add(ActionFrameBuilder.getInstance().setEvent(EventFactory.textMessage(jaction.getInput())).addReplies(JsonToActionFrameHandler.processReplies(jaction)).build());
        }
        return list;
    }

    private static List<Reply<? extends Message>> processReplies(JsonAction jaction) {
        ArrayList<Reply<? extends Message>> replies = new ArrayList<Reply<? extends Message>>();
        for (final JsonReply jsonReply : jaction.getReplies()) {
            if (jsonReply.getType().equals(CONST_TEXT)) {
                replies.add(ReplyFactory.buildTextMessageReply(jsonReply.getText().getBody()));
            }
            if (jsonReply.getType().equals("picture")) {
                replies.add(new PictureMessageReply(){

                    @Override
                    public PictureMessage processReply(Message message) {
                        return PictureMessageBuilder.getInstance().setPicUrl(jsonReply.getPicture().getPicUrl()).build();
                    }
                });
            }
            if (jsonReply.getType().equals("video")) {
                replies.add(new VideoMessageReply(){

                    @Override
                    public VideoMessage processReply(Message message) {
                        return VideoMessageBuilder.getInstance().setVideoUrl(jsonReply.getVideo().getVideoUrl()).build();
                    }
                });
            }
            if (!jsonReply.getType().equals("link")) continue;
            replies.add(new LinkMessageReply(){

                @Override
                public LinkMessage processReply(Message message) {
                    return LinkMessageBuilder.getInstance().setText(jsonReply.getLink().getText()).setTitle(jsonReply.getLink().getTitle()).setUrl(jsonReply.getLink().getUrl()).build();
                }
            });
        }
        return replies;
    }
}

