/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.incoming.handler;

import co.aurasphere.botmill.kik.KikBotMillContext;
import co.aurasphere.botmill.kik.incoming.model.IncomingMessage;
import co.aurasphere.botmill.kik.model.Frame;
import co.aurasphere.botmill.kik.model.Message;
import co.aurasphere.botmill.kik.model.MessagePostback;
import co.aurasphere.botmill.kik.model.Reply;
import co.aurasphere.botmill.kik.network.NetworkUtils;
import co.aurasphere.botmill.kik.outgoing.model.IsTypingMessage;
import co.aurasphere.botmill.kik.outgoing.model.LinkMessage;
import co.aurasphere.botmill.kik.outgoing.model.OutgoingMessage;
import co.aurasphere.botmill.kik.outgoing.model.PictureMessage;
import co.aurasphere.botmill.kik.outgoing.model.ReadReceiptMessage;
import co.aurasphere.botmill.kik.outgoing.model.TextMessage;
import co.aurasphere.botmill.kik.outgoing.model.VideoMessage;
import co.aurasphere.botmill.kik.outgoing.reply.IsTypingReply;
import co.aurasphere.botmill.kik.outgoing.reply.LinkMessageReply;
import co.aurasphere.botmill.kik.outgoing.reply.PictureMessageReply;
import co.aurasphere.botmill.kik.outgoing.reply.ReadReceiptReply;
import co.aurasphere.botmill.kik.outgoing.reply.TextMessageReply;
import co.aurasphere.botmill.kik.outgoing.reply.VideoMessageReply;
import java.util.ArrayList;
import java.util.List;

public class IncomingToOutgoingMessageHandler {
    private static IncomingToOutgoingMessageHandler instance;

    public static IncomingToOutgoingMessageHandler createHandler() {
        if (instance == null) {
            instance = new IncomingToOutgoingMessageHandler();
        }
        return instance;
    }

    public IncomingToOutgoingMessageHandler processBroadcast(Message message) {
        this.handleOutgoingMessage(KikBotMillContext.getInstance().getBroadcastMessageActionFrames(), message, true);
        return this;
    }

    public IncomingToOutgoingMessageHandler process(Message message) {
        ArrayList<Frame> actionFrames = new ArrayList<Frame>();
        actionFrames.addAll(KikBotMillContext.getInstance().getActionFrames());
        actionFrames.addAll(KikBotMillContext.getInstance().getAnyEventActionFrames());
        this.handleOutgoingMessage(actionFrames, message, false);
        return this;
    }

    private void handleOutgoingMessage(List<Frame> actionFrames, Message message, boolean broadcast) {
        MessagePostback postback = null;
        if (actionFrames.size() > 0) {
            for (Frame frame : actionFrames) {
                if (!frame.getEvent().verifyEvent((IncomingMessage)message)) continue;
                postback = new MessagePostback();
                for (Reply<? extends Message> reply : frame.getReplies()) {
                    OutgoingMessage outgoingMessage = null;
                    if (reply instanceof TextMessageReply) {
                        outgoingMessage = new TextMessage();
                        outgoingMessage = (TextMessage)reply.processReply(message);
                    } else if (reply instanceof PictureMessageReply) {
                        outgoingMessage = new PictureMessage();
                        outgoingMessage = (PictureMessage)reply.processReply(message);
                    } else if (reply instanceof LinkMessageReply) {
                        outgoingMessage = new LinkMessage();
                        outgoingMessage = (LinkMessage)reply.processReply(message);
                    } else if (reply instanceof VideoMessageReply) {
                        outgoingMessage = new VideoMessage();
                        outgoingMessage = (VideoMessage)reply.processReply(message);
                    } else if (reply instanceof IsTypingReply) {
                        outgoingMessage = new IsTypingMessage();
                        outgoingMessage = (IsTypingMessage)reply.processReply(message);
                    } else if (reply instanceof ReadReceiptReply) {
                        outgoingMessage = new ReadReceiptMessage();
                        outgoingMessage = (ReadReceiptMessage)reply.processReply(message);
                    }
                    if (outgoingMessage == null) continue;
                    outgoingMessage.setTo(((IncomingMessage)message).getFrom());
                    outgoingMessage.setChatId(message.getChatId());
                    postback.addMessage(outgoingMessage);
                }
            }
            if (postback != null) {
                if (broadcast) {
                    NetworkUtils.postJsonMessageBroadcast(postback);
                } else {
                    NetworkUtils.postJsonMessage(postback);
                }
            }
        }
    }
}

