/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.factory;

import co.aurasphere.botmill.kik.builder.ActionMessageBuilder;
import co.aurasphere.botmill.kik.builder.LinkMessageBuilder;
import co.aurasphere.botmill.kik.builder.PictureMessageBuilder;
import co.aurasphere.botmill.kik.builder.TextMessageBuilder;
import co.aurasphere.botmill.kik.builder.VideoMessageBuilder;
import co.aurasphere.botmill.kik.model.Message;
import co.aurasphere.botmill.kik.outgoing.model.IsTypingMessage;
import co.aurasphere.botmill.kik.outgoing.model.LinkMessage;
import co.aurasphere.botmill.kik.outgoing.model.PictureMessage;
import co.aurasphere.botmill.kik.outgoing.model.TextMessage;
import co.aurasphere.botmill.kik.outgoing.model.VideoMessage;
import co.aurasphere.botmill.kik.outgoing.reply.IsTypingReply;
import co.aurasphere.botmill.kik.outgoing.reply.LinkMessageReply;
import co.aurasphere.botmill.kik.outgoing.reply.PictureMessageReply;
import co.aurasphere.botmill.kik.outgoing.reply.TextMessageReply;
import co.aurasphere.botmill.kik.outgoing.reply.VideoMessageReply;

public class ReplyFactory {
    public static TextMessageReply buildTextMessageReply(final String text) {
        return new TextMessageReply(){

            @Override
            public TextMessage processReply(Message message) {
                return TextMessageBuilder.getInstance().setBody(text).build();
            }
        };
    }

    public static PictureMessageReply buildPictureMessageReply(final String pictureUrl) {
        return new PictureMessageReply(){

            @Override
            public PictureMessage processReply(Message message) {
                return PictureMessageBuilder.getInstance().setPicUrl(pictureUrl).build();
            }
        };
    }

    public static IsTypingReply buildTypingReply() {
        return new IsTypingReply(){

            @Override
            public IsTypingMessage processReply(Message message) {
                return ActionMessageBuilder.buildIsTypingMessage();
            }
        };
    }

    public static VideoMessageReply buildVideoMessageReply(final String videoUrl) {
        return new VideoMessageReply(){

            @Override
            public VideoMessage processReply(Message message) {
                return VideoMessageBuilder.getInstance().setVideoUrl(videoUrl).build();
            }
        };
    }

    public static LinkMessageReply buildLinkMessageReply(final String title, final String link, final String pictureUrl) {
        return new LinkMessageReply(){

            @Override
            public LinkMessage processReply(Message message) {
                return LinkMessageBuilder.getInstance().setTitle(title).setUrl(link).setPicUrl(pictureUrl).build();
            }
        };
    }
}

