/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.incoming.handler;

import co.aurasphere.botmill.kik.KikBotMillContext;
import co.aurasphere.botmill.kik.incoming.model.IncomingMessage;
import co.aurasphere.botmill.kik.model.Frame;
import co.aurasphere.botmill.kik.model.Message;
import co.aurasphere.botmill.kik.model.MessagePostback;
import co.aurasphere.botmill.kik.model.Reply;
import co.aurasphere.botmill.kik.network.NetworkUtils;
import co.aurasphere.botmill.kik.outgoing.model.IsTypingMessage;
import co.aurasphere.botmill.kik.outgoing.model.LinkMessage;
import co.aurasphere.botmill.kik.outgoing.model.OutgoingMessage;
import co.aurasphere.botmill.kik.outgoing.model.PictureMessage;
import co.aurasphere.botmill.kik.outgoing.model.ReadReceiptMessage;
import co.aurasphere.botmill.kik.outgoing.model.TextMessage;
import co.aurasphere.botmill.kik.outgoing.model.VideoMessage;
import co.aurasphere.botmill.kik.outgoing.reply.AnyReply;
import co.aurasphere.botmill.kik.outgoing.reply.IsTypingReply;
import co.aurasphere.botmill.kik.outgoing.reply.LinkMessageReply;
import co.aurasphere.botmill.kik.outgoing.reply.PictureMessageReply;
import co.aurasphere.botmill.kik.outgoing.reply.ReadReceiptReply;
import co.aurasphere.botmill.kik.outgoing.reply.TextMessageReply;
import co.aurasphere.botmill.kik.outgoing.reply.VideoMessageReply;
import java.util.List;

public class IncomingToOutgoingMessageHandler {
    private static IncomingToOutgoingMessageHandler instance;

    public static IncomingToOutgoingMessageHandler createHandler() {
        if (instance == null) {
            instance = new IncomingToOutgoingMessageHandler();
        }
        return instance;
    }

    public IncomingToOutgoingMessageHandler processBroadcast(Message message) {
        this.outgoingHandler(KikBotMillContext.getInstance().getBroadcastMessageActionFrames(), message, true);
        return this;
    }

    public IncomingToOutgoingMessageHandler process(Message message) {
        switch (message.getType()) {
            case TEXT: {
                this.outgoingHandler(KikBotMillContext.getInstance().getTextMessageActionFrames(), message, false);
                break;
            }
            case PICTURE: {
                this.outgoingHandler(KikBotMillContext.getInstance().getMediaMessageActionFrames(), message, false);
                break;
            }
            case VIDEO: {
                this.outgoingHandler(KikBotMillContext.getInstance().getMediaMessageActionFrames(), message, false);
                break;
            }
            case LINK: {
                this.outgoingHandler(KikBotMillContext.getInstance().getLinkMessageActionFrames(), message, false);
                break;
            }
            default: {
                this.outgoingHandler(KikBotMillContext.getInstance().getActionFrames(), message, false);
            }
        }
        return this;
    }

    private void outgoingHandler(List<Frame> actionFrames, Message message, boolean broadcast) {
        MessagePostback postback = null;
        if (actionFrames.size() > 0) {
            for (Frame frame : actionFrames) {
                if (!frame.getEvent().verifyEvent((IncomingMessage)message)) continue;
                postback = new MessagePostback();
                for (Reply<? extends Message> reply : frame.getReplies()) {
                    OutgoingMessage outgoingMessage;
                    if (reply instanceof TextMessageReply) {
                        outgoingMessage = new TextMessage();
                        outgoingMessage = (TextMessage)reply.processReply(message);
                        outgoingMessage.setTo(((IncomingMessage)message).getFrom());
                        outgoingMessage.setChatId(message.getChatId());
                        postback.addMessage(outgoingMessage);
                        continue;
                    }
                    if (reply instanceof PictureMessageReply) {
                        outgoingMessage = new PictureMessage();
                        outgoingMessage = (PictureMessage)reply.processReply(message);
                        outgoingMessage.setTo(((IncomingMessage)message).getFrom());
                        outgoingMessage.setChatId(message.getChatId());
                        postback.addMessage(outgoingMessage);
                        continue;
                    }
                    if (reply instanceof LinkMessageReply) {
                        outgoingMessage = new LinkMessage();
                        outgoingMessage = (LinkMessage)reply.processReply(message);
                        outgoingMessage.setTo(((IncomingMessage)message).getFrom());
                        outgoingMessage.setChatId(message.getChatId());
                        postback.addMessage(outgoingMessage);
                        continue;
                    }
                    if (reply instanceof VideoMessageReply) {
                        outgoingMessage = new VideoMessage();
                        outgoingMessage = (VideoMessage)reply.processReply(message);
                        outgoingMessage.setTo(((IncomingMessage)message).getFrom());
                        outgoingMessage.setChatId(message.getChatId());
                        postback.addMessage(outgoingMessage);
                        continue;
                    }
                    if (reply instanceof IsTypingReply) {
                        outgoingMessage = new IsTypingMessage();
                        outgoingMessage = (IsTypingMessage)reply.processReply(message);
                        outgoingMessage.setTo(((IncomingMessage)message).getFrom());
                        outgoingMessage.setChatId(message.getChatId());
                        postback.addMessage(outgoingMessage);
                        continue;
                    }
                    if (reply instanceof ReadReceiptReply) {
                        outgoingMessage = new ReadReceiptMessage();
                        outgoingMessage = (ReadReceiptMessage)reply.processReply(message);
                        outgoingMessage.setTo(((IncomingMessage)message).getFrom());
                        outgoingMessage.setChatId(message.getChatId());
                        postback.addMessage(outgoingMessage);
                        continue;
                    }
                    if (!(reply instanceof AnyReply)) continue;
                    outgoingMessage = (OutgoingMessage)reply.processReply(message);
                    outgoingMessage.setTo(((IncomingMessage)message).getFrom());
                    outgoingMessage.setChatId(message.getChatId());
                    postback.addMessage(outgoingMessage);
                }
            }
            if (postback != null) {
                if (broadcast) {
                    NetworkUtils.postJsonMessageBroadcast(postback);
                } else {
                    NetworkUtils.postJsonMessage(postback);
                }
            }
        }
    }
}

