/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.builder;

import co.aurasphere.botmill.kik.builder.KeyboardBuilder;
import co.aurasphere.botmill.kik.model.BaseBuilder;
import co.aurasphere.botmill.kik.model.Buildable;
import co.aurasphere.botmill.kik.model.Keyboardable;
import co.aurasphere.botmill.kik.model.MediaAttribution;
import co.aurasphere.botmill.kik.model.MessageType;
import co.aurasphere.botmill.kik.outgoing.model.VideoMessage;

public class VideoMessageBuilder
extends BaseBuilder
implements Keyboardable<VideoMessageBuilder>,
Buildable<VideoMessage> {
    private static VideoMessage videoMessage;
    private static VideoMessageBuilder instance;
    private static KeyboardBuilder<VideoMessageBuilder> keyboardBuilder;

    public static VideoMessageBuilder getInstance() {
        if (instance == null) {
            instance = new VideoMessageBuilder();
        }
        videoMessage = new VideoMessage();
        videoMessage.setType(MessageType.VIDEO);
        return instance;
    }

    public VideoMessageBuilder() {
        videoMessage = new VideoMessage();
        videoMessage.setType(MessageType.VIDEO);
    }

    public VideoMessageBuilder setVideoUrl(String videoUrl) {
        videoMessage.setVideoUrl(videoUrl);
        return this;
    }

    public VideoMessageBuilder setLoop(boolean loop) {
        videoMessage.setLoop(loop);
        return this;
    }

    public VideoMessageBuilder setMuted(boolean muted) {
        videoMessage.setMuted(muted);
        return this;
    }

    public VideoMessageBuilder setAutoplay(boolean autoplay) {
        videoMessage.setAutoplay(autoplay);
        return this;
    }

    public VideoMessageBuilder setNoSave(boolean nosave) {
        videoMessage.setNoSave(nosave);
        return this;
    }

    @Override
    public KeyboardBuilder<VideoMessageBuilder> addKeyboard() {
        keyboardBuilder = new KeyboardBuilder<VideoMessageBuilder>(this);
        videoMessage.addKeyboard(keyboardBuilder.buildKeyboard());
        return keyboardBuilder;
    }

    @Override
    public VideoMessageBuilder endKeyboard() {
        return (VideoMessageBuilder)keyboardBuilder.getParentBuilder();
    }

    @Override
    public VideoMessage build() {
        videoMessage.setAttribution(MediaAttribution.CAMERA);
        return videoMessage;
    }
}

