/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.builder;

import co.aurasphere.botmill.kik.builder.KeyboardBuilder;
import co.aurasphere.botmill.kik.model.BaseBuilder;
import co.aurasphere.botmill.kik.model.Buildable;
import co.aurasphere.botmill.kik.model.Keyboardable;
import co.aurasphere.botmill.kik.model.MediaAttribution;
import co.aurasphere.botmill.kik.model.MessageType;
import co.aurasphere.botmill.kik.outgoing.model.PictureMessage;

public class PictureMessageBuilder
extends BaseBuilder
implements Keyboardable<PictureMessageBuilder>,
Buildable<PictureMessage> {
    private static PictureMessage pictureMessage;
    private static PictureMessageBuilder instance;
    private static KeyboardBuilder<PictureMessageBuilder> keyboardBuilder;

    public static PictureMessageBuilder getInstance() {
        if (instance == null) {
            instance = new PictureMessageBuilder();
        }
        pictureMessage = new PictureMessage();
        pictureMessage.setType(MessageType.PICTURE);
        return instance;
    }

    public PictureMessageBuilder() {
        pictureMessage = new PictureMessage();
        pictureMessage.setType(MessageType.PICTURE);
    }

    public PictureMessageBuilder setTo(String to) {
        pictureMessage.setTo(to);
        return this;
    }

    public PictureMessageBuilder setPicUrl(String picUrl) {
        pictureMessage.setPicUrl(picUrl);
        return this;
    }

    @Override
    public KeyboardBuilder<PictureMessageBuilder> addKeyboard() {
        keyboardBuilder = new KeyboardBuilder<PictureMessageBuilder>(this);
        pictureMessage.addKeyboard(keyboardBuilder.buildKeyboard());
        return keyboardBuilder;
    }

    @Override
    public PictureMessageBuilder endKeyboard() {
        return (PictureMessageBuilder)keyboardBuilder.getParentBuilder();
    }

    @Override
    public PictureMessage build() {
        pictureMessage.setAttribution(MediaAttribution.GALLERY);
        return pictureMessage;
    }
}

