/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.builder;

import co.aurasphere.botmill.kik.builder.KeyboardBuilder;
import co.aurasphere.botmill.kik.model.Attribution;
import co.aurasphere.botmill.kik.model.BaseBuilder;
import co.aurasphere.botmill.kik.model.Buildable;
import co.aurasphere.botmill.kik.model.Keyboardable;
import co.aurasphere.botmill.kik.model.KikJsData;
import co.aurasphere.botmill.kik.model.MessageType;
import co.aurasphere.botmill.kik.outgoing.model.LinkMessage;

public class LinkMessageBuilder
extends BaseBuilder
implements Keyboardable<LinkMessageBuilder>,
Buildable<LinkMessage> {
    private static LinkMessage linkMessage;
    private static LinkMessageBuilder instance;
    private static KeyboardBuilder<LinkMessageBuilder> keyboardBuilder;

    public static LinkMessageBuilder getInstance() {
        if (instance == null) {
            instance = new LinkMessageBuilder();
        }
        linkMessage = new LinkMessage();
        linkMessage.setType(MessageType.LINK);
        return instance;
    }

    public LinkMessageBuilder() {
        linkMessage = new LinkMessage();
        linkMessage.setType(MessageType.LINK);
    }

    public LinkMessageBuilder setUrl(String url) {
        linkMessage.setUrl(url);
        return this;
    }

    public LinkMessageBuilder setTitle(String title) {
        linkMessage.setTitle(title);
        return this;
    }

    public LinkMessageBuilder setText(String text) {
        linkMessage.setText(text);
        return this;
    }

    public LinkMessageBuilder setPicUrl(String picUrl) {
        linkMessage.setPicUrl(picUrl);
        return this;
    }

    public LinkMessageBuilder setNoForward(boolean noForward) {
        linkMessage.setNoForward(noForward);
        return this;
    }

    public LinkMessageBuilder setKikJsData(KikJsData kikJsData) {
        linkMessage.setKikJsData(kikJsData);
        return this;
    }

    public LinkMessageBuilder setAttribution(Attribution attribution) {
        linkMessage.setAttribution(attribution);
        return this;
    }

    @Override
    public KeyboardBuilder<LinkMessageBuilder> addKeyboard() {
        keyboardBuilder = new KeyboardBuilder<LinkMessageBuilder>(this);
        linkMessage.addKeyboard(keyboardBuilder.buildKeyboard());
        return keyboardBuilder;
    }

    @Override
    public LinkMessageBuilder endKeyboard() {
        return (LinkMessageBuilder)keyboardBuilder.getParentBuilder();
    }

    @Override
    public LinkMessage build() {
        return linkMessage;
    }
}

