/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.builder;

import co.aurasphere.botmill.kik.builder.KeyboardBuilder;
import co.aurasphere.botmill.kik.configuration.Configuration;
import co.aurasphere.botmill.kik.model.BaseBuilder;
import co.aurasphere.botmill.kik.model.Keyboardable;

public class ConfigurationBuilder
extends BaseBuilder
implements Keyboardable<ConfigurationBuilder> {
    private Configuration config = new Configuration();
    private static ConfigurationBuilder instance;
    private KeyboardBuilder<ConfigurationBuilder> keyboardBuilder;

    public static ConfigurationBuilder getInstance() {
        if (instance == null) {
            instance = new ConfigurationBuilder();
        }
        return instance;
    }

    public ConfigurationBuilder setWebhook(String webhook) {
        this.config.setWebhook(webhook);
        return this;
    }

    public ConfigurationBuilder setManuallySendReadReceipts(boolean manuallySendReadReceipts) {
        this.config.getFeatures().setManuallySendReadReceipts(manuallySendReadReceipts);
        return this;
    }

    public ConfigurationBuilder setReceiveReadReceipts(boolean receiveReadReceipts) {
        this.config.getFeatures().setReceiveReadReceipts(receiveReadReceipts);
        return this;
    }

    public ConfigurationBuilder setReceiveIsTyping(boolean receiveIsTyping) {
        this.config.getFeatures().setReceiveIsTyping(receiveIsTyping);
        return this;
    }

    public ConfigurationBuilder setReceiveDeliveryReceipts(boolean receiveDeliveryReceipts) {
        this.config.getFeatures().setReceiveDeliveryReceipts(receiveDeliveryReceipts);
        return this;
    }

    @Override
    public KeyboardBuilder<ConfigurationBuilder> addKeyboard() {
        this.keyboardBuilder = new KeyboardBuilder<ConfigurationBuilder>(this);
        return this.keyboardBuilder;
    }

    @Override
    public ConfigurationBuilder endKeyboard() {
        return (ConfigurationBuilder)this.keyboardBuilder.getParentBuilder();
    }

    public Configuration buildConfiguration() {
        if (this.keyboardBuilder != null) {
            this.config.setStaticKeyBoard(this.keyboardBuilder.buildKeyboard());
        }
        return this.config;
    }
}

