/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik;

import co.aurasphere.botmill.kik.KikBotMillEntry;
import co.aurasphere.botmill.kik.incoming.handler.IncomingToOutgoingMessageHandler;
import co.aurasphere.botmill.kik.json.JsonUtils;
import co.aurasphere.botmill.kik.model.Message;
import co.aurasphere.botmill.kik.model.MessageCallback;
import java.io.IOException;
import java.io.Reader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KikBotMillServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(KikBotMillServlet.class);

    public void init() throws ServletException {
        String botDefinitionClass = this.getServletConfig().getInitParameter("bot-definition-class");
        if (botDefinitionClass == null || botDefinitionClass.isEmpty()) {
            logger.error("Bot definition class not found in web.xml. Make sure to add the fully qualified name of the a class implementing co.aurasphere.botmill.fb.KikBotDefinition as an init-param of the FbBotMillServlet.");
            throw new ServletException("Bot definition class not found in web.xml. Make sure to add the fully qualified name of the a class implementing co.aurasphere.botmill.fb.KikBotDefinition as an init-param of the FbBotMillServlet.");
        }
        KikBotMillEntry botEntry = null;
        try {
            botEntry = (KikBotMillEntry)((Object)((Object)this)).getClass().getClassLoader().loadClass(botDefinitionClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.error("Error while loading KikBotDefinition class [ " + botDefinitionClass + " ]", (Throwable)e);
            throw new ServletException("Error while loading KikBotDefinition class [ " + botDefinitionClass + " ]", (Throwable)e);
        }
        catch (ClassCastException e) {
            logger.error("Class [ " + botDefinitionClass + " ] does not implement co.aurasphere.botmill.kik.KikBotDefinition", (Throwable)e);
            throw new ServletException("Class [ " + botDefinitionClass + " ] does not implement co.aurasphere.botmill.kik.KikBotDefinition", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Error during instantiation of class [ " + botDefinitionClass + " ]", (Throwable)e);
            throw new ServletException("Error during instantiation of class [ " + botDefinitionClass + " ]", (Throwable)e);
        }
        botEntry.kikBotEntry();
        logger.info("KikBotMillServlet configuration OK.");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String json = KikBotMillServlet.readerToString(req.getReader());
            logger.debug("JSON INPUT: " + json);
            MessageCallback messages = JsonUtils.fromJson(json, MessageCallback.class);
            for (Message message : messages.getMessages()) {
                IncomingToOutgoingMessageHandler.createHandler().process(message);
                IncomingToOutgoingMessageHandler.createHandler().processBroadcast(message);
            }
        }
        catch (Exception e) {
            logger.error("Error during MessengerCallback parsing: ", (Throwable)e);
            return;
        }
        finally {
            resp.setStatus(200);
        }
    }

    private static String readerToString(Reader reader) throws IOException {
        int numCharsRead;
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numCharsRead);
        }
        return buffer.toString();
    }

    public String toString() {
        return "KikBotMillServlet []";
    }
}

