/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.core.internal.util.network;

import co.aurasphere.botmill.core.internal.util.network.BotMillNetworkResponse;
import co.aurasphere.botmill.core.internal.util.network.HttpDeleteWithBody;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetworkUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BotMillNetworkResponse send(HttpRequestBase request) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        logger.debug("HTTP request: {}", (Object)request.getRequestLine().toString());
        CloseableHttpResponse httpResponse = null;
        String responseContent = null;
        BotMillNetworkResponse response = new BotMillNetworkResponse();
        try {
            httpResponse = httpClient.execute((HttpUriRequest)request);
            responseContent = NetworkUtils.getResponseContent((HttpResponse)httpResponse);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            logger.debug("HTTP Status Code: {}", (Object)statusCode);
            if (statusCode >= 400) {
                logger.error("HTTP connection failed with error code {}.", (Object)statusCode);
                response.setError(true);
            }
        }
        catch (Exception e) {
            logger.error("Error during HTTP connection: ", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                logger.error("Error while closing HTTP connection: ", (Throwable)e);
            }
        }
        response.setResponse(responseContent);
        return response;
    }

    private static String getResponseContent(HttpResponse response) throws IOException {
        InputStream inputStream = response.getEntity().getContent();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        InputStreamReader inputStreamReader = new InputStreamReader(bufferedInputStream);
        BufferedReader br = new BufferedReader(inputStreamReader);
        StringBuilder builder = new StringBuilder();
        String output = null;
        while ((output = br.readLine()) != null) {
            builder.append(output);
        }
        String responseContent = builder.toString();
        logger.debug("Raw response: {}", (Object)responseContent);
        return responseContent;
    }

    public static BotMillNetworkResponse post(String url, StringEntity entity) {
        HttpPost post = new HttpPost(url);
        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
        post.setEntity((HttpEntity)entity);
        return NetworkUtils.send((HttpRequestBase)post);
    }

    public static BotMillNetworkResponse get(String url) {
        HttpGet get = new HttpGet(url);
        return NetworkUtils.send((HttpRequestBase)get);
    }

    public static BotMillNetworkResponse delete(String url, StringEntity entity) {
        HttpDeleteWithBody delete = new HttpDeleteWithBody(url);
        delete.setEntity((HttpEntity)entity);
        return NetworkUtils.send((HttpRequestBase)delete);
    }

    public static BotMillNetworkResponse delete(String url) {
        HttpDelete delete = new HttpDelete(url);
        return NetworkUtils.send((HttpRequestBase)delete);
    }

    public String toString() {
        return "NetworkUtils []";
    }
}

