/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.core.internal.util;

import co.aurasphere.botmill.core.BotDefinition;
import co.aurasphere.botmill.core.annotation.Bot;
import co.aurasphere.botmill.core.annotation.BotEncryption;
import co.aurasphere.botmill.core.internal.exception.BotMillConfigurationException;
import java.lang.reflect.Modifier;
import java.util.Properties;
import java.util.Set;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PBEStringCleanablePasswordEncryptor;
import org.jasypt.properties.EncryptableProperties;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUtils.class);
    private static Properties configuration = new Properties();
    private static EncryptableProperties encryptedConfiguration;
    private static final String CONFIG_PATH = "botmill.properties";

    private ConfigurationUtils() {
    }

    public static void loadBotDefinitions() {
        Reflections ref = new Reflections(new Object[0]);
        Set botDefinitions = ref.getSubTypesOf(BotDefinition.class);
        if (botDefinitions.isEmpty()) {
            logger.warn("No bot definition found on the classpath. Make sure to have at least one class implementing the BotDefinition interface.");
        }
        for (Class defClass : botDefinitions) {
            if (!defClass.isAnnotationPresent(Bot.class) || Modifier.isAbstract(defClass.getModifiers())) continue;
            try {
                BotDefinition instance = (BotDefinition)defClass.newInstance();
                instance.defineBehaviour();
            }
            catch (ClassCastException e) {
                logger.error("Class [{}] does not implement co.aurasphere.botmill.common.BotDefinition.", (Object)defClass, (Object)e);
                throw new BotMillConfigurationException("Class [ " + defClass + " ] does not implement co.aurasphere.botmill.common.BotDefinition.", e);
            }
            catch (Exception e) {
                logger.error("Error during instantiation of class [{}].", (Object)defClass, (Object)e);
                throw new BotMillConfigurationException("Error during instantiation of class [ " + defClass + " ].", e);
            }
        }
    }

    public static void loadEncryptedConfigurationProperties() {
        Reflections ref = new Reflections(new Object[0]);
        Set botEncryptions = ref.getTypesAnnotatedWith(BotEncryption.class);
        for (Class botEncryption : botEncryptions) {
            try {
                botEncryption.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadConfigurationFile() {
        try {
            if (configuration == null) {
                configuration = new Properties();
            }
            configuration.load(ConfigurationUtils.class.getClassLoader().getResourceAsStream(CONFIG_PATH));
        }
        catch (Exception e) {
            logger.error("Error while loading BotMill properties file ({})", (Object)CONFIG_PATH, (Object)e);
        }
    }

    public static void loadEncryptedConfigurationFile(PBEStringCleanablePasswordEncryptor encryptor, String classpathProperties) {
        try {
            if (encryptedConfiguration == null) {
                encryptedConfiguration = new EncryptableProperties((StringEncryptor)encryptor);
            }
            encryptedConfiguration.load(ConfigurationUtils.class.getClassLoader().getResourceAsStream(classpathProperties));
        }
        catch (Exception e) {
            logger.error("Error while loading BotMill properties file ({})", (Object)CONFIG_PATH, (Object)e);
        }
    }

    public static void setEncryptedPropertiesEncryptor(PBEStringCleanablePasswordEncryptor encryptor) {
        try {
            if (encryptedConfiguration == null) {
                encryptedConfiguration = new EncryptableProperties((StringEncryptor)encryptor);
            }
            encryptedConfiguration.load(ConfigurationUtils.class.getClassLoader().getResourceAsStream(CONFIG_PATH));
        }
        catch (Exception e) {
            logger.error("Error while loading BotMill properties file ({})", (Object)CONFIG_PATH, (Object)e);
        }
    }

    public static Properties getConfiguration() {
        return configuration;
    }

    public static EncryptableProperties getEncryptedConfiguration() {
        return encryptedConfiguration;
    }

    public static void setConfiguration(Properties configuration) {
        ConfigurationUtils.configuration = configuration;
    }

    public static void setEncryptedConfiguration(EncryptableProperties encryptedConfiguration) {
        ConfigurationUtils.encryptedConfiguration = encryptedConfiguration;
    }

    public String toString() {
        return "ConfigurationUtils []";
    }
}

