/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.core.datastore.adapter;

import co.aurasphere.botmill.core.datastore.adapter.BotDataAdapter;
import co.aurasphere.botmill.core.datastore.model.KeyValuePair;
import co.aurasphere.botmill.core.datastore.model.Session;
import co.aurasphere.botmill.core.internal.util.ConfigurationUtils;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDBAdapter
extends BotDataAdapter<MongoOperations> {
    @Override
    public void setup() {
        MongoCredential credential = MongoCredential.createCredential((String)ConfigurationUtils.getConfiguration().getProperty("mongodb.username"), (String)ConfigurationUtils.getConfiguration().getProperty("mongodb.database"), (char[])ConfigurationUtils.getConfiguration().getProperty("mongodb.password").toCharArray());
        ServerAddress serverAddress = new ServerAddress(ConfigurationUtils.getConfiguration().getProperty("mongodb.server"), Integer.valueOf(ConfigurationUtils.getConfiguration().getProperty("mongodb.port")).intValue());
        MongoClient mongoClient = new MongoClient(serverAddress, Arrays.asList(credential));
        SimpleMongoDbFactory simpleMongoDbFactory = new SimpleMongoDbFactory((Mongo)mongoClient, ConfigurationUtils.getConfiguration().getProperty("mongodb.database"));
        MongoTemplate mongoTemplate = new MongoTemplate((MongoDbFactory)simpleMongoDbFactory);
        this.source = mongoTemplate;
    }

    @Override
    public Session buildSession(String identifier) {
        Query q = new Query(Criteria.where((String)"identifier").is((Object)identifier));
        Session sessionResult = (Session)((MongoOperations)this.source).findOne(q, Session.class);
        if (sessionResult == null) {
            Session session = new Session();
            session.setIdentifier(identifier);
            session.setKeyValuePair(new ArrayList<KeyValuePair>());
            ((MongoOperations)this.source).save((Object)session);
            Query newSessionQ = new Query(Criteria.where((String)"identifier").is((Object)identifier));
            Session newSession = (Session)((MongoOperations)this.source).findOne(newSessionQ, Session.class);
            return newSession;
        }
        return sessionResult;
    }

    @Override
    public void destroySession(String identifier) {
        Query q = new Query(Criteria.where((String)"identifier").is((Object)identifier));
        ((MongoOperations)this.source).remove(q, Session.class);
    }

    @Override
    public Session putData(String identifier, KeyValuePair keyValuePair) {
        this.buildSession(identifier);
        Query q = new Query(Criteria.where((String)"identifier").is((Object)identifier));
        Session sessionResult = (Session)((MongoOperations)this.source).findOne(q, Session.class);
        sessionResult.addKeyValuePair(keyValuePair);
        ((MongoOperations)this.source).save((Object)sessionResult);
        return sessionResult;
    }

    @Override
    public void removeData(String identifier, String key) {
        Query q = new Query(Criteria.where((String)"identifier").is((Object)identifier).and("KeyValuePairs.key").is((Object)key));
        ((MongoOperations)this.source).remove(q, Session.class);
    }

    @Override
    public Session getSession(String identifier) {
        Query q = new Query(Criteria.where((String)"identifier").is((Object)identifier));
        Session sessionResult = (Session)((MongoOperations)this.source).findOne(q, Session.class);
        return sessionResult;
    }

    @Override
    public KeyValuePair getData(String identifier, String key) {
        Query q = new Query(Criteria.where((String)"identifier").is((Object)identifier).and("KeyValuePairs.key").is((Object)key));
        Session sessionResult = (Session)((MongoOperations)this.source).findOne(q, Session.class);
        return sessionResult.getKeyValuePairs().get(0);
    }
}

