/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.core.datastore.adapter;

import co.aurasphere.botmill.core.datastore.adapter.BotDataAdapter;
import co.aurasphere.botmill.core.datastore.model.KeyValuePair;
import co.aurasphere.botmill.core.datastore.model.Session;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapAdapter
extends BotDataAdapter<ConcurrentMap<String, Session>> {
    @Override
    public void setup() {
        this.source = new ConcurrentHashMap();
    }

    @Override
    public Session buildSession(String identifier) {
        Session session = new Session();
        session.setIdentifier(identifier);
        session.setKeyValuePair(new ArrayList<KeyValuePair>());
        ((ConcurrentMap)this.source).put(identifier, session);
        if (((ConcurrentMap)this.source).containsKey(identifier)) {
            return (Session)((ConcurrentMap)this.source).get(identifier);
        }
        return session;
    }

    @Override
    public Session getSession(String identifier) {
        if (((ConcurrentMap)this.source).containsKey(identifier)) {
            return (Session)((ConcurrentMap)this.source).get(identifier);
        }
        return this.buildSession(identifier);
    }

    @Override
    public void destroySession(String identifier) {
        if (((ConcurrentMap)this.source).containsKey(identifier)) {
            ((ConcurrentMap)this.source).remove(identifier);
        }
    }

    @Override
    public Session putData(String identifier, KeyValuePair keyValuePair) {
        if (((ConcurrentMap)this.source).containsKey(identifier)) {
            ((Session)((ConcurrentMap)this.source).get(identifier)).addKeyValuePair(keyValuePair);
            return (Session)((ConcurrentMap)this.source).get(identifier);
        }
        return null;
    }

    @Override
    public void removeData(String identifier, String key) {
        if (((ConcurrentMap)this.source).containsKey(identifier)) {
            for (KeyValuePair keyValuePair : ((Session)((ConcurrentMap)this.source).get(identifier)).getKeyValuePairs()) {
                if (!keyValuePair.getKey().equals(key)) continue;
                ((Session)((ConcurrentMap)this.source).get(identifier)).getKeyValuePairs().remove(keyValuePair);
                break;
            }
        }
    }

    @Override
    public KeyValuePair getData(String identifier, String key) {
        if (((ConcurrentMap)this.source).containsKey(identifier)) {
            for (KeyValuePair keyValuePair : ((Session)((ConcurrentMap)this.source).get(identifier)).getKeyValuePairs()) {
                if (!keyValuePair.getKey().equals(key)) continue;
                return keyValuePair;
            }
        }
        return null;
    }

    public String toString() {
        return ((ConcurrentMap)this.source).toString();
    }
}

