/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.core.datastore.adapter;

import co.aurasphere.botmill.core.datastore.adapter.BotDataAdapter;
import co.aurasphere.botmill.core.datastore.model.KeyValuePair;
import co.aurasphere.botmill.core.datastore.model.Session;
import co.aurasphere.botmill.core.internal.util.ConfigurationUtils;
import co.aurasphere.botmill.core.internal.util.JsonUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqlAdapter
extends BotDataAdapter<Connection> {
    @Override
    public void setup() {
        try {
            Class.forName(ConfigurationUtils.getConfiguration().getProperty("hsql.driver"));
            Connection c = DriverManager.getConnection(ConfigurationUtils.getConfiguration().getProperty("hsql.conn.url"), ConfigurationUtils.getConfiguration().getProperty("hsql.username"), ConfigurationUtils.getConfiguration().getProperty("hsql.password"));
            this.source = c;
            DatabaseMetaData dbMeta = ((Connection)this.source).getMetaData();
            ResultSet tableMeta = dbMeta.getTables(null, null, ConfigurationUtils.getConfiguration().getProperty("hsql.table.prefix") + "_SESSION", null);
            if (!tableMeta.next()) {
                ((Connection)this.source).prepareStatement("CREATE TABLE " + ConfigurationUtils.getConfiguration().getProperty("hsql.table.prefix") + "_SESSION (IDENTIFIER VARCHAR(255), KEYVALUEPAIR TEXT)").executeQuery();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("SQL Exception");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            logger.error("Driver not found in classpath");
        }
    }

    @Override
    public Session buildSession(String identifier) {
        try {
            PreparedStatement preparedStatement = ((Connection)this.source).prepareStatement("SELECT * FROM " + ConfigurationUtils.getConfiguration().getProperty("hsql.table.prefix") + "_SESSION " + "WHERE " + "\tIDENTIFIER = ?");
            preparedStatement.setString(1, identifier);
            ResultSet rs = preparedStatement.executeQuery();
            Session session = new Session();
            if (rs.getRow() != 0) {
                session.setIdentifier(rs.getString(0));
                if (!rs.getString(1).equals("")) {
                    session.addKeyValuePair(JsonUtils.fromJson(rs.getString(1), KeyValuePair.class));
                }
                return session;
            }
            PreparedStatement createRecord = ((Connection)this.source).prepareStatement("INSERT INTO " + ConfigurationUtils.getConfiguration().getProperty("hsql.table.prefix") + "_SESSION(IDENTIFIER) " + "VALUES(?) ");
            createRecord.setString(1, identifier);
            createRecord.executeQuery();
            this.buildSession(identifier);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void destroySession(String identifier) {
    }

    @Override
    public Session putData(String identifier, KeyValuePair keyValuePair) {
        return null;
    }

    @Override
    public void removeData(String identifier, String key) {
    }

    @Override
    public Session getSession(String identifier) {
        return null;
    }

    @Override
    public KeyValuePair getData(String identifier, String key) {
        return null;
    }
}

