/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.core;

import co.aurasphere.botmill.core.datastore.adapter.DataAdapter;
import co.aurasphere.botmill.core.datastore.adapter.DataAdapterFactory;
import co.aurasphere.botmill.core.datastore.adapter.DataAdapterType;
import co.aurasphere.botmill.core.datastore.model.KeyValuePair;
import co.aurasphere.botmill.core.datastore.model.KeyValuePairBuilder;
import co.aurasphere.botmill.core.datastore.model.Session;
import co.aurasphere.botmill.core.internal.util.ConfigurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotMillSession {
    private static final Logger logger = LoggerFactory.getLogger(BotMillSession.class);
    private static DataAdapter dataAdapter;
    private static BotMillSession instance;

    public static BotMillSession getInstance() {
        if (instance == null) {
            instance = new BotMillSession();
        }
        return instance;
    }

    private BotMillSession() {
        String dataAdapterType = ConfigurationUtils.getConfiguration().getProperty("data.adapter.type");
        if (dataAdapterType == null || dataAdapterType.equals("map")) {
            this.defineDataAdapter(DataAdapterType.MAP);
        } else if (dataAdapterType.equals("mongodb")) {
            this.defineDataAdapter(DataAdapterType.MONGODB);
        } else if (dataAdapterType.equals("hsql")) {
            this.defineDataAdapter(DataAdapterType.HSQL);
        } else if (dataAdapterType.equals("rdbms")) {
            this.defineDataAdapter(DataAdapterType.RBDMS);
        } else {
            logger.info("No Data Adapter Type specified on the botmill.properties, defaulting to Map");
            this.defineDataAdapter(DataAdapterType.MAP);
        }
    }

    private void defineDataAdapter(DataAdapterType adapterType) {
        switch (adapterType) {
            case MAP: {
                dataAdapter = DataAdapterFactory.getMapAdapter();
                break;
            }
            case MONGODB: {
                dataAdapter = DataAdapterFactory.getMongoDbAdapter();
                break;
            }
            case HSQL: {
                dataAdapter = DataAdapterFactory.getHsqlAdapter();
                break;
            }
            case RBDMS: {
                dataAdapter = DataAdapterFactory.getRdbmsAdapter();
                break;
            }
            default: {
                logger.error("Data Adapter not defined.");
            }
        }
    }

    public Session buildSession(String identifier) {
        return dataAdapter.buildSession(identifier);
    }

    public void destroySession(String identifier) {
        dataAdapter.destroySession(identifier);
    }

    public Session getSession(String identifier) {
        return dataAdapter.getSession(identifier);
    }

    public Session putSessionData(String identifier, KeyValuePair keyValuePair) {
        return dataAdapter.putData(identifier, keyValuePair);
    }

    public void removeSessionData(String identifier, String key) {
        dataAdapter.removeData(identifier, key);
    }

    public KeyValuePair getSessionData(String identifier, String key) {
        return dataAdapter.getData(identifier, key);
    }

    public KeyValuePair addKeyValuePair(String key, String value) {
        return KeyValuePairBuilder.getInstance().setKey(key).setValue(value).build();
    }
}

