/*
 * Decompiled with CFR 0.152.
 */
package co.arcs.groove.thresher;

import co.arcs.groove.thresher.Client;
import co.arcs.groove.thresher.GroovesharkException;
import co.arcs.groove.thresher.RequestBuilder;
import co.arcs.groove.thresher.Session;
import co.arcs.groove.thresher.Song;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class User {
    private final Client client;
    private final Library library = new Library();
    private final Favorites favorites = new Favorites();
    private final long id;
    private final String email;
    private final String password;

    User(Client client, String email, String password, JsonNode node) throws GroovesharkException.InvalidCredentialsException {
        this.client = client;
        JsonNode result = node.get("result");
        this.id = result.get("userID").asLong();
        if (this.id == 0L) {
            throw new GroovesharkException.InvalidCredentialsException();
        }
        this.email = email;
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public Library library() {
        return this.library;
    }

    public Favorites favorites() {
        return this.favorites;
    }

    public class Favorites {
        public boolean add(final Song song) throws IOException, GroovesharkException {
            JsonNode response = User.this.client.sendRequest(new RequestBuilder("favorite", false){

                @Override
                void populateParameters(Session session, ObjectNode parameters) {
                    parameters.put("what", "Song");
                    parameters.put("ID", song.getId());
                }
            });
            return response.get("result").get("success").asBoolean();
        }

        public boolean remove(final Song song) throws IOException, GroovesharkException {
            JsonNode response = User.this.client.sendRequest(new RequestBuilder("unfavorite", false){

                @Override
                void populateParameters(Session session, ObjectNode parameters) {
                    parameters.put("what", "Song");
                    parameters.put("ID", song.getId());
                }
            });
            return response.get("result").get("success").asBoolean();
        }

        public List<Song> get() throws IOException, GroovesharkException {
            JsonNode response = User.this.client.sendRequest(new RequestBuilder("getFavorites", false){

                @Override
                void populateParameters(Session session, ObjectNode parameters) {
                    parameters.put("ofWhat", "Songs");
                    parameters.put("userID", User.this.id);
                }
            });
            ArrayList songs = Lists.newArrayList();
            Iterator elements = response.get("result").elements();
            while (elements.hasNext()) {
                songs.add(new Song((JsonNode)elements.next()));
            }
            return songs;
        }
    }

    public class Library {
        public List<Song> get() throws IOException, GroovesharkException {
            JsonNode response = User.this.client.sendRequest(new RequestBuilder("userGetSongsInLibrary", false){

                @Override
                void populateParameters(Session session, ObjectNode parameters) {
                    parameters.put("userID", User.this.id);
                    parameters.put("page", 0);
                }
            });
            ArrayList songs = Lists.newArrayList();
            Iterator elements = response.get("result").get("Songs").elements();
            while (elements.hasNext()) {
                songs.add(new Song((JsonNode)elements.next()));
            }
            return songs;
        }

        public boolean add(final Song ... songs) throws IOException, GroovesharkException {
            JsonNode response = User.this.client.sendRequest(new RequestBuilder("userAddSongsToLibrary", false){

                @Override
                void populateParameters(Session session, ObjectNode parameters) {
                    ArrayNode songsNode = parameters.putArray("songs");
                    for (Song s : songs) {
                        ObjectNode songNode = songsNode.objectNode();
                        songNode.put("songID", s.getId());
                        songNode.put("artistID", s.getArtistId());
                        songNode.put("albumID", s.getAlbumId());
                        songsNode.add((JsonNode)songNode);
                    }
                }
            });
            return response.get("result").get("Timestamps").has("newTSModified");
        }

        public boolean remove(final Song ... songs) throws IOException, GroovesharkException {
            JsonNode response = User.this.client.sendRequest(new RequestBuilder("userRemoveSongsFromLibrary", false){

                @Override
                void populateParameters(Session session, ObjectNode parameters) {
                    parameters.put("userID", User.this.id);
                    ArrayNode albumsNode = parameters.putArray("albumIDs");
                    ArrayNode artistsNode = parameters.putArray("artistIDs");
                    ArrayNode songsNode = parameters.putArray("songIDs");
                    for (Song s : songs) {
                        songsNode.add(s.getId());
                        artistsNode.add(s.getArtistId());
                        albumsNode.add(s.getAlbumId());
                    }
                }
            });
            return response.get("result").get("Timestamps").has("newTSModified");
        }
    }
}

