/*
 * Decompiled with CFR 0.152.
 */
package co.arcs.groove.thresher;

import com.fasterxml.jackson.databind.JsonNode;
import javax.annotation.Nullable;

public class Song {
    private final int id;
    private final String name;
    private final int track;
    private final int duration;
    private final String coverArtFilename;
    private final boolean lowBitrateAvailable;
    private final int popularity;
    private final int year;
    private final int albumId;
    private final String albumName;
    private final int artistId;
    private final String artistName;
    private final UserData userData;

    Song(JsonNode node) {
        this.id = node.get("SongID").asInt();
        this.name = node.has("Name") ? node.get("Name").asText() : node.get("SongName").asText();
        this.track = node.get("TrackNum").asInt();
        this.duration = node.get("EstimateDuration").asInt();
        this.coverArtFilename = node.get("CoverArtFilename").asText();
        this.lowBitrateAvailable = node.get("IsLowBitrateAvailable").asBoolean();
        this.popularity = node.get("Popularity").asInt();
        this.year = node.has("Year") ? node.get("Year").asInt() : 0;
        this.albumId = node.get("AlbumID").asInt();
        this.albumName = node.get("AlbumName").asText();
        this.artistId = node.get("ArtistID").asInt();
        this.artistName = node.get("ArtistName").asText();
        String timeFavorited = node.has("TSFavorited") ? node.get("TSFavorited").asText() : null;
        String timeAdded = node.has("TSAdded") ? node.get("TSAdded").asText() : timeFavorited;
        this.userData = timeAdded != null || timeFavorited != null ? new UserData(timeAdded, timeFavorited) : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Song other = (Song)obj;
        return this.id == other.id;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public int getTrack() {
        return this.track;
    }

    public int getDuration() {
        return this.duration;
    }

    @Nullable
    public String getCoverArtFilename() {
        return this.coverArtFilename;
    }

    public boolean isLowBitrateAvailable() {
        return this.lowBitrateAvailable;
    }

    public int getPopularity() {
        return this.popularity;
    }

    public int getYear() {
        return this.year;
    }

    public int getAlbumId() {
        return this.albumId;
    }

    @Nullable
    public String getAlbumName() {
        return this.albumName;
    }

    public int getArtistId() {
        return this.artistId;
    }

    @Nullable
    public String getArtistName() {
        return this.artistName;
    }

    @Nullable
    public UserData getUserData() {
        return this.userData;
    }

    public static class UserData {
        private final String timeAdded;
        private final String timeFavorited;
        private final boolean favorited;
        private final boolean collected;

        public UserData(String timeAdded, String timeFavorited) {
            this.timeFavorited = timeFavorited;
            this.timeAdded = timeAdded != null ? timeAdded : timeFavorited;
            this.favorited = timeFavorited != null;
            this.collected = timeAdded != null;
        }

        @Nullable
        public String getTimeAdded() {
            return this.timeAdded;
        }

        @Nullable
        public String getTimeFavorited() {
            return this.timeFavorited;
        }

        public boolean isFavorited() {
            return this.favorited;
        }

        public boolean isCollected() {
            return this.collected;
        }
    }
}

