/*
 * Decompiled with CFR 0.152.
 */
package co.arcs.groove.thresher;

import co.arcs.groove.thresher.Client;
import co.arcs.groove.thresher.DigestUtils;
import co.arcs.groove.thresher.GroovesharkException;
import co.arcs.groove.thresher.User;
import com.belladati.httpclientandroidlib.Header;
import com.belladati.httpclientandroidlib.HeaderElement;
import com.belladati.httpclientandroidlib.HttpEntity;
import com.belladati.httpclientandroidlib.HttpResponse;
import com.belladati.httpclientandroidlib.client.methods.HttpPost;
import com.belladati.httpclientandroidlib.client.methods.HttpUriRequest;
import com.belladati.httpclientandroidlib.entity.StringEntity;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

class Session {
    private final Client client;
    private final String phpSession;
    private final long phpSessionCreatedTime;
    private final String secretKey;
    private final String uuid;
    private final JsonNode country;
    @Nullable
    private String commsToken;
    private User user;
    private static final long PHP_SESSION_LIFETIME = 604800L;

    Session(Client api, HttpResponse response) throws JsonProcessingException, IOException, GroovesharkException {
        this.client = api;
        this.phpSession = Session.extractPhpSession(response);
        Preconditions.checkNotNull((Object)this.phpSession);
        this.phpSessionCreatedTime = new Date().getTime();
        this.country = this.extractCountry(response);
        Preconditions.checkNotNull((Object)this.country);
        this.secretKey = Session.generateSecretKey(this.phpSession);
        this.uuid = Session.generateUuid();
    }

    Session(Client api, String phpSession, JsonNode country, String secretKey, String uuid, String commsToken) {
        this.client = api;
        this.phpSession = phpSession;
        this.phpSessionCreatedTime = new Date().getTime();
        this.country = country;
        this.secretKey = secretKey;
        this.uuid = uuid;
        this.commsToken = commsToken;
    }

    @Nullable
    private JsonNode extractCountry(HttpResponse response) throws IOException {
        String responseBody = CharStreams.toString((Readable)new InputStreamReader(response.getEntity().getContent(), Charsets.UTF_8));
        Matcher matcher = Pattern.compile("window.tokenData = (.*);").matcher(responseBody);
        if (matcher.find()) {
            String json = matcher.group(1);
            JsonNode rootNode = this.client.getJsonMapper().readTree((Reader)new StringReader(json));
            JsonNode gsConfigNode = rootNode.get("getGSConfig");
            if (gsConfigNode != null) {
                return gsConfigNode.get("country");
            }
        }
        return null;
    }

    @Nullable
    private static String extractPhpSession(HttpResponse response) throws IOException {
        Header[] headers;
        for (Header header : headers = response.getHeaders("Set-Cookie")) {
            HeaderElement[] elements;
            for (HeaderElement element : elements = header.getElements()) {
                if (!"PHPSESSID".equals(element.getName())) continue;
                return element.getValue();
            }
        }
        return null;
    }

    private static String generateSecretKey(String phpSession) {
        return DigestUtils.md5Hex(phpSession);
    }

    private static String generateUuid() {
        return UUID.randomUUID().toString().toUpperCase(Locale.US);
    }

    void createCommsToken() throws IOException, GroovesharkException {
        JsonNode jsonNode;
        String method = "getCommunicationToken";
        JsonNodeFactory nodeFactory = JsonNodeFactory.instance;
        ObjectNode rootNode = nodeFactory.objectNode();
        ObjectNode header = nodeFactory.objectNode();
        header.put("client", "mobileshark");
        header.put("clientRevision", "20120830");
        header.put("country", this.country);
        header.put("privacy", 0);
        header.put("session", this.phpSession);
        header.put("uuid", this.uuid);
        rootNode.put("header", (JsonNode)header);
        rootNode.put("method", method);
        ObjectNode parameters = JsonNodeFactory.instance.objectNode();
        parameters.put("secretKey", this.secretKey);
        rootNode.put("parameters", (JsonNode)parameters);
        String url = "https://grooveshark.com/more.php#" + method;
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setEntity((HttpEntity)new StringEntity(rootNode.toString()));
        HttpResponse httpResponse = this.client.getHttpClient().execute((HttpUriRequest)httpRequest);
        String payload = CharStreams.toString((Readable)new InputStreamReader(httpResponse.getEntity().getContent(), Charsets.UTF_8));
        try {
            jsonNode = this.client.getJsonMapper().readTree((Reader)new StringReader(payload));
        }
        catch (JsonProcessingException e) {
            throw new GroovesharkException.ServerErrorException("Failed to parse response - was not valid JSON: " + payload);
        }
        this.commsToken = jsonNode.get("result").asText();
    }

    void createCommsTokenAsRequired() throws IOException, GroovesharkException {
        if (this.commsToken == null) {
            this.createCommsToken();
        }
    }

    boolean isExpired() {
        return this.phpSessionCreatedTime + 604800L < new Date().getTime();
    }

    void setAuthenticated(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    boolean hasUser() {
        return this.user != null;
    }

    public String getPhpSession() {
        return this.phpSession;
    }

    public JsonNode getCountry() {
        return this.country;
    }

    @Nullable
    public String getCommsToken() {
        return this.commsToken;
    }

    public String getUuid() {
        return this.uuid;
    }
}

