/*
 * Decompiled with CFR 0.152.
 */
package co.arcs.groove.thresher;

import co.arcs.groove.thresher.GroovesharkException;
import co.arcs.groove.thresher.RequestBuilder;
import co.arcs.groove.thresher.Session;
import co.arcs.groove.thresher.Song;
import co.arcs.groove.thresher.User;
import com.belladati.httpclientandroidlib.HttpEntity;
import com.belladati.httpclientandroidlib.HttpResponse;
import com.belladati.httpclientandroidlib.client.HttpClient;
import com.belladati.httpclientandroidlib.client.config.RequestConfig;
import com.belladati.httpclientandroidlib.client.methods.HttpGet;
import com.belladati.httpclientandroidlib.client.methods.HttpPost;
import com.belladati.httpclientandroidlib.client.methods.HttpRequestBase;
import com.belladati.httpclientandroidlib.client.methods.HttpUriRequest;
import com.belladati.httpclientandroidlib.conn.HttpClientConnectionManager;
import com.belladati.httpclientandroidlib.entity.BufferedHttpEntity;
import com.belladati.httpclientandroidlib.impl.client.HttpClients;
import com.belladati.httpclientandroidlib.impl.conn.PoolingHttpClientConnectionManager;
import com.belladati.httpclientandroidlib.message.BasicHeader;
import com.belladati.httpclientandroidlib.util.EntityUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class Client {
    static final String DOMAIN = "grooveshark.com";
    private static final int TIMEOUT = 10000;
    private boolean debugLogging = false;
    private final HttpClient httpClient;
    private final ObjectMapper jsonMapper;
    private Session session;

    public Client() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(2);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).build();
        ArrayList headers = Lists.newArrayList((Object[])new BasicHeader[]{new BasicHeader("Accept-Encoding", "gzip,deflate")});
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultHeaders((Collection)headers).setDefaultRequestConfig(requestConfig).setUserAgent("").build();
        this.jsonMapper = new ObjectMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsonNode sendRequest(RequestBuilder requestBuilder) throws IOException, GroovesharkException {
        this.createSessionIfRequired();
        this.session.createCommsTokenAsRequired();
        boolean sessionAlreadyRenewed = false;
        boolean commsTokenAlreadyRenewed = false;
        while (true) {
            if (!sessionAlreadyRenewed) {
                this.createSessionIfRequired();
            }
            if (!commsTokenAlreadyRenewed) {
                this.session.createCommsTokenAsRequired();
            }
            HttpPost httpRequest = requestBuilder.build(this.session);
            try {
                JsonNode jsonNode = this.executeRequest(httpRequest);
                GroovesharkException exception = Client.mapGroovesharkFaultCodeToException(jsonNode);
                if (exception != null) {
                    if (exception instanceof GroovesharkException.InvalidSessionException) {
                        if (sessionAlreadyRenewed) {
                            throw new GroovesharkException.ServerErrorException("Failed with invalid session. Renewed session still invalid.");
                        }
                        this.createSession();
                        sessionAlreadyRenewed = true;
                        continue;
                    }
                    if (exception instanceof GroovesharkException.InvalidCommsTokenException) {
                        if (commsTokenAlreadyRenewed) {
                            throw new GroovesharkException.ServerErrorException("Failed with invalid comms token. Renewed token also invalid.");
                        }
                        this.session.createCommsToken();
                        commsTokenAlreadyRenewed = true;
                        continue;
                    }
                    throw exception;
                }
                JsonNode jsonNode2 = jsonNode;
                return jsonNode2;
            }
            finally {
                httpRequest.reset();
                continue;
            }
            break;
        }
    }

    private JsonNode executeRequest(HttpPost request) throws IOException, GroovesharkException {
        HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        if (this.debugLogging) {
            this.logRequest((HttpRequestBase)request, response);
        }
        String responsePayload = CharStreams.toString((Readable)new InputStreamReader(response.getEntity().getContent(), Charsets.UTF_8));
        try {
            return this.jsonMapper.readTree((Reader)new StringReader(responsePayload));
        }
        catch (JsonProcessingException e) {
            throw new GroovesharkException.ServerErrorException("Failed to parse response - received data was not valid JSON: " + responsePayload);
        }
    }

    private static GroovesharkException mapGroovesharkFaultCodeToException(JsonNode jsonNode) {
        if (jsonNode.has("fault")) {
            JsonNode faultNode = jsonNode.get("fault");
            int faultCode = faultNode.get("code").asInt();
            switch (faultCode) {
                case 16: {
                    return new GroovesharkException.InvalidSessionException(faultNode);
                }
                case 256: {
                    return new GroovesharkException.InvalidCommsTokenException(faultNode);
                }
                case 512: {
                    return new GroovesharkException.RateLimitedException(faultNode);
                }
            }
            return new GroovesharkException.ServerErrorException(faultNode);
        }
        return null;
    }

    private void createSessionIfRequired() throws IOException, GroovesharkException {
        if (this.session == null || this.session.isExpired()) {
            this.createSession();
        }
    }

    private void createSession() throws IOException, GroovesharkException {
        User userFromOldSession = this.session == null ? null : this.session.getUser();
        HttpGet request = new HttpGet("http://grooveshark.com/preload.php?getCommunicationToken");
        HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        if (this.debugLogging) {
            this.logRequest((HttpRequestBase)request, response);
        }
        Session session = new Session(this, response);
        if (userFromOldSession != null) {
            this.login(userFromOldSession.getEmail(), userFromOldSession.getPassword());
        } else {
            this.session = session;
        }
    }

    private void logRequest(HttpRequestBase request, HttpResponse response) throws IOException {
        try {
            ObjectWriter writer = this.jsonMapper.writer().withDefaultPrettyPrinter();
            System.out.println("=== REQUEST ===");
            System.out.println(request.getURI().toString());
            if (request instanceof HttpPost) {
                String requestPayload = CharStreams.toString((Readable)new InputStreamReader(((HttpPost)request).getEntity().getContent()));
                JsonNode requestNode = this.jsonMapper.readTree(requestPayload);
                System.out.println(writer.writeValueAsString((Object)requestNode));
            } else {
                System.out.println("(No body)");
            }
            System.out.println("=== RESPONSE ===");
            if (response.getEntity() != null) {
                BufferedHttpEntity entity = new BufferedHttpEntity(response.getEntity());
                response.setEntity((HttpEntity)entity);
                String responsePayload = CharStreams.toString((Readable)new InputStreamReader(entity.getContent()));
                try {
                    JsonNode responseNode = this.jsonMapper.readTree(responsePayload);
                    System.out.println(writer.writeValueAsString((Object)responseNode));
                }
                catch (JsonProcessingException e) {
                    System.out.println(responsePayload);
                }
            } else {
                System.out.println("(No body)");
            }
            System.out.println();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public InputStream getStream(Song song) throws IOException, GroovesharkException {
        return this.getStream(song.getId());
    }

    public InputStream getStream(long songId) throws IOException, GroovesharkException {
        return this.getStreamResponse(songId).getEntity().getContent();
    }

    public HttpResponse getStreamResponse(Song song) throws IOException, GroovesharkException {
        return this.getStreamResponse(song.getId());
    }

    public HttpResponse getStreamResponse(long songId) throws IOException, GroovesharkException {
        HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(this.getStreamUrl(songId).toString()));
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            throw new IOException("API returned " + statusCode + " status code");
        }
        return response;
    }

    public URL getStreamUrl(Song song) throws IOException, GroovesharkException {
        return this.getStreamUrl(song.getId());
    }

    public URL getStreamUrl(final long songId) throws IOException, GroovesharkException {
        JsonNode response = this.sendRequest(new RequestBuilder("getStreamKeyFromSongIDEx", false){

            @Override
            void populateParameters(Session session, ObjectNode parameters) {
                parameters.put("type", 0);
                parameters.put("prefetch", false);
                parameters.put("songID", songId);
                parameters.put("country", session.getCountry());
                parameters.put("mobile", false);
            }
        });
        JsonNode result = response.get("result");
        if (result.size() == 0) {
            throw new GroovesharkException.ServerErrorException("Received empty response");
        }
        String ip = result.get("ip").asText();
        String streamKey = result.get("streamKey").asText();
        return new URL("http://" + ip + "/stream.php?streamKey=" + streamKey);
    }

    public List<Song> searchSongs(final String query) throws IOException, GroovesharkException {
        JsonNode response = this.sendRequest(new RequestBuilder("getResultsFromSearch", false){

            @Override
            void populateParameters(Session session, ObjectNode parameters) {
                parameters.put("type", "Songs");
                parameters.put("query", query);
            }
        });
        ArrayList songs = Lists.newArrayList();
        Iterator elements = response.get("result").get("result").elements();
        while (elements.hasNext()) {
            songs.add(new Song((JsonNode)elements.next()));
        }
        return songs;
    }

    public List<Song> searchPopularSongs() throws IOException, GroovesharkException {
        JsonNode response = this.sendRequest(new RequestBuilder("popularGetSongs", false){

            @Override
            void populateParameters(Session session, ObjectNode parameters) {
                parameters.put("type", "daily");
            }
        });
        ArrayList songs = Lists.newArrayList();
        Iterator elements = response.get("result").get("Songs").elements();
        while (elements.hasNext()) {
            songs.add(new Song((JsonNode)elements.next()));
        }
        return songs;
    }

    public User login(final String username, final String password) throws IOException, GroovesharkException {
        JsonNode node = this.sendRequest(new RequestBuilder("authenticateUser", true){

            @Override
            void populateParameters(Session session, ObjectNode parameters) {
                parameters.put("username", username);
                parameters.put("password", password);
            }
        });
        User user = new User(this, username, password, node);
        this.session.setAuthenticated(user);
        return user;
    }

    @Nullable
    public User getUser() {
        return this.session.getUser();
    }

    public void setDebugLoggingEnabled(boolean enabled) {
        this.debugLogging = enabled;
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }
}

