/*
 * Decompiled with CFR 0.152.
 */
package co.ambisafe.keyserver.service;

import co.ambisafe.keyserver.exception.JsonParseException;
import co.ambisafe.keyserver.exception.ParsingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private final Logger LOG = LoggerFactory.getLogger(JsonUtils.class);

    public void validateJson(JsonNode json) {
        if (json.isMissingNode()) {
            throw new JsonParseException("Content must not be null");
        }
    }

    public void validateJson(JsonNode json, String path) {
        if (json.isMissingNode()) {
            throw new JsonParseException("`" + path + "` must not be null");
        }
    }

    public void checkNotEmpty(String value) {
        if (value.equals("")) {
            throw new JsonParseException("Content must not be empty");
        }
    }

    public void checkNotEmpty(String value, String errorMsg) {
        if (value.equals("")) {
            throw new JsonParseException("Content must not be empty. " + errorMsg);
        }
    }

    public List<String> getListFromJsonNode(JsonNode json, String listNodeName) {
        JsonNode node = json.path(listNodeName);
        this.validateJson(node, listNodeName);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(node.elements(), 16), false).map(JsonNode::asText).collect(Collectors.toList());
    }

    public Map<String, String> getMap(JsonNode json, String nodeName) {
        JsonNode map = json.path(nodeName);
        this.validateJson(map);
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
        try {
            return (Map)mapper.readValue(mapper.writeValueAsString((Object)map), (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new ParsingException("Can't parse map from " + nodeName);
        }
    }
}

