/*
 * Decompiled with CFR 0.152.
 */
package co.ambisafe.keyserver.dto.internal;

import co.ambisafe.keyserver.asset.CryptoAsset;
import co.ambisafe.keyserver.dto.internal.ContainerWrapper;
import co.ambisafe.keyserver.schema.SecuritySchema;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;

public class AccountWrapper {
    public CryptoAsset asset;
    public SecuritySchema securitySchema;
    public List<ContainerWrapper> containers = new ArrayList<ContainerWrapper>();
    public long id;
    public String externalId;
    public String currencyFamilySymbol;
    public String securitySchemaName;
    public String address;
    public Date createdAt;
    public Date updatedAt;

    public Optional<ContainerWrapper> getContainerByRole(int role) {
        for (ContainerWrapper containerWrapper : this.containers) {
            if (containerWrapper.role != role) continue;
            return Optional.of(containerWrapper);
        }
        return Optional.empty();
    }

    public List<byte[]> getAllPubKeys() {
        TreeSet<ContainerWrapper> sortedSet = new TreeSet<ContainerWrapper>(new Comparator<ContainerWrapper>(){

            @Override
            public int compare(ContainerWrapper o1, ContainerWrapper o2) {
                if (o1.role == o2.role) {
                    return 0;
                }
                if (o1.role > o2.role) {
                    return 1;
                }
                return -1;
            }
        });
        for (ContainerWrapper containerWrapper : this.containers) {
            sortedSet.add(containerWrapper);
        }
        ArrayList<byte[]> pubKeys = new ArrayList<byte[]>();
        for (ContainerWrapper containerWrapper : sortedSet) {
            pubKeys.add(containerWrapper.publicKey);
        }
        return pubKeys;
    }
}

