package co.ambisafe.keyserver.service;

import co.ambisafe.keyserver.dto.internal.AccountWrapper;
import co.ambisafe.keyserver.dto.internal.ContainerWrapper;
import co.ambisafe.keyserver.dto.internal.ContainerWrapperData;
import co.ambisafe.keyserver.dto.internal.KeyPair;
import co.ambisafe.keyserver.dto.request.AccountRequest;
import com.fasterxml.jackson.databind.JsonNode;

public interface ContainerService {
    ContainerWrapper getContainerFromRequest(AccountRequest request, String roleKey, int role);

    ContainerWrapper getContainerFromRequest(AccountRequest request, JsonNode containerNode, String roleName, int role);

    void createRandomKeysContainer(AccountWrapper data, String roleKey, int role, String secret);

    void createContainersFromWif(AccountWrapper data, AccountRequest request, final int role,
                                 final String roleName, final String secret);

    void createContainerFromKeyPair(AccountWrapper data, String roleName, int role, String secret, KeyPair keyPair);

    byte[] getPrivateKeyForContainer(ContainerWrapper container, String secret);

    void removeContainerByRole(AccountWrapper wrapper, int role);

    ContainerWrapperData parseContainerData(ContainerWrapper containerWrapper);

    AccountWrapper getRecoveryAccountWithContainers(String address);
}