package co.ambisafe.keyserver.supernode;

import co.ambisafe.keyserver.exception.SuperNodeException;

import java.util.Date;
import java.util.List;

public interface SuperNode {
    /**
     * Submit any valid protocol transaction in raw (hex) form
     * @param rawTxHex
     * @return transaction id
     * @throws SuperNodeException
     */
    String sendToNetwork(String rawTxHex) throws SuperNodeException;

    /**
     * Return all available info about transaction. For Bitcoin it will be transaction hex that contains all transaction info.
     * @param transactionId
     * @return
     * @throws SuperNodeException
     */
    String getTransaction(String transactionId) throws SuperNodeException;

    /**
     * Should return the latest block (ledger for Ripple and Stellar) found by the network
     * @return last block
     * @throws SuperNodeException
     */
    Long getLatestBlock() throws SuperNodeException;

    List<String> getRawTransactions(long block) throws SuperNodeException;

    /**
     * Since most of consensus networks are used for financial-related transactions, in most cases we'll need an ability to fetch balance for specific address. The number of arguments will be different, based on protocol specifics. For example it may be necessary to specify asset id, number of confirmations etc.
     * @param args
     * @return balance
     * @throws SuperNodeException
     */
    Object getBalance(String... args) throws SuperNodeException;

    /**
     * Should return super node unique id name
     * @return
     */
    String getSuperNodeName();

    /**
     * Method used to mark super node as failed. It is called by internal Keyserver classes, but you can call it too if you realize that it is only available behaviour to mark as failed withour throwing exception.
     * @param failed
     */
    void markFailed(Boolean failed);

    /**
     * Method to get state of super node. You can override this behaviour integrating reseting failed by timeout.
     * @return
     */
    Boolean isFailed();

    /**
     * Get time of last failure.
     * @return
     */
    Date getFailedAt();
}