package co.abit.prime.web.request;

import java.util.Optional;

public interface ParameterRequest {
    /**
     * Get parameter's value by key
     * @param key a string represents for key
     * @return a string represents for parameter's value or null if key is not found
     */
    Optional<String> get(String key);

    /**
     * Get a list of values
     * @param key a string represents for key
     * @param type class of value
     * @param <T> type of value
     * @return an Optional value of an array of values
     * @throws UnsupportedOperationException if type is not supported
     */
    <T> Optional<T[]> getList(String key, Class<T> type) throws UnsupportedOperationException;

    /**
     * Get a list of strings of values
     * @param key a string represents for key
     * @return an array of string values
     */
    default Optional<String[]> getList(String key) {
        try {
            return getList(key, String.class);
        } catch (UnsupportedOperationException e) {
            return Optional.empty();
        }
    }
}
