package co.abit.prime.web.request;

import java.util.Iterator;
import java.util.Optional;

public interface HeaderRequest {
    /**
     * Return value of request's header
     * @param name a string represents for header's name
     * @return an Optional value of string
     */
    Optional<String> getHeader(String name);

    /**
     * Return the request header values for the given header name,
     * <p>A single-value header will be exposed as an array with a single element.
     * @param name a string represents for header's name
     * @return an Optional value of an array of string
     */
    Optional<String[]> getHeaderValues(String name);

    /**
     * Return a Iterator over request header names.
     * @return an iterator of string
     */
    Iterator<String> getHeaderNames();
}
