package co.abit.prime.web.request;

import java.util.ArrayList;
import java.util.List;

public interface ParameterizedRequest {
    /**
     * Get parameter's value by key
     * @param key a string represents for key
     * @return a string represents for parameter's value or null if key is not found
     */
    default String get(String key) {
        return getOrDefault(key, null);
    }

    /**
     * Get parameter's value by key or return default value
     * @param key a string represents for key
     * @param def a default value to be returned when key is not found
     * @return a string value
     */
    String getOrDefault(String key, String def);

    /**
     * Get a list of values
     * @param key a string represents for key
     * @param type class of value
     * @param <T> type of value
     * @return a list of values
     * @throws UnsupportedOperationException if type is not supported
     */
    <T> List<T> getList(String key, Class<T> type) throws UnsupportedOperationException;

    /**
     * Get a list of strings of values
     * @param key a string represents for key
     * @return a list of string values
     */
    default List<String> getList(String key) {
        try {
            return getList(key, String.class);
        } catch (UnsupportedOperationException e) {
            return new ArrayList<>();
        }
    }
}
