package co.abit.prime.repository.reactor;

import reactor.core.publisher.Mono;

public interface CrudRepository<T> {
    Mono<Void> insert(T t);
    Mono<Void> update(T t);
    Mono<Void> delete(Long id);
    default Mono<Void> delete(String id) {
        return Mono.error(new UnsupportedOperationException());
    }
}