package co.abit.prime.repository;

import co.abit.prime.util.convertible.PrimeMapConvertible;
import org.springframework.data.domain.Pageable;

import java.util.List;

public interface PrimeRepository<T extends PrimeMapConvertible> extends CrudRepository<T> {
    T findById(Long id);
    default T findById(String id) {
        throw new UnsupportedOperationException();
    }

    default List<T> findAll() {
        throw new UnsupportedOperationException();
    }
    default List<T> findAll(Pageable pageable) {
        throw new UnsupportedOperationException();
    }
}
