/*
 * Decompiled with CFR 0.152.
 */
package co.abit.prime.domain;

import co.abit.prime.domain.Permission;
import co.abit.prime.domain.PrimeAuthorizedObject;
import co.abit.prime.domain.Role;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface AuthorizedObject {
    public List<Role> getRoles();

    public void setRoles(List<Role> var1);

    default public void setRoles(Role ... roles) {
        this.setRoles(Arrays.asList(roles));
    }

    public List<Permission> getPermissions();

    public void setPermissions(List<Permission> var1);

    default public void setPermissions(Permission ... permissions) {
        this.setPermissions(Arrays.asList(permissions));
    }

    default public boolean has(Role ... roles) {
        for (Role role : roles) {
            if (!this.getRoles().contains(role)) continue;
            return true;
        }
        return false;
    }

    default public boolean has(Permission ... permissions) {
        for (Permission permission : permissions) {
            if (!this.getPermissions().contains(permission)) continue;
            return true;
        }
        return false;
    }

    public static AuthorizedObject newInstance() {
        return PrimeAuthorizedObject.builder().roles(new ArrayList<Role>()).permissions(new ArrayList<Permission>()).build();
    }

    public static AuthorizedObject from(List<Role> roles, List<Permission> permissions) {
        AuthorizedObject authorizedObject = AuthorizedObject.newInstance();
        authorizedObject.setRoles(roles);
        authorizedObject.setPermissions(permissions);
        return authorizedObject;
    }

    public static AuthorizedObject from(Role ... roles) {
        AuthorizedObject authorizedObject = AuthorizedObject.newInstance();
        authorizedObject.setRoles(roles);
        return authorizedObject;
    }

    public static AuthorizedObject from(Permission ... permissions) {
        AuthorizedObject authorizedObject = AuthorizedObject.newInstance();
        authorizedObject.setPermissions(permissions);
        return authorizedObject;
    }
}

