/*
 * Decompiled with CFR 0.152.
 */
package co.abit.prime.domain;

import co.abit.prime.domain.Authenticable;
import co.abit.prime.domain.Authorizable;
import co.abit.prime.domain.Grantable;
import co.abit.prime.domain.Permission;
import co.abit.prime.domain.Role;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;

@JsonPropertyOrder(value={"id", "subject", "identifier", "roles", "permissions"})
class GrantedObject
implements Grantable {
    @JsonIgnore
    private Authenticable authenticable;
    @JsonIgnore
    private Authorizable authorizable;

    @Override
    public String getId() {
        return this.authenticable.getId();
    }

    @Override
    public String getIdentifier() {
        return this.authenticable.getIdentifier();
    }

    @Override
    public String getSubject() {
        return this.authenticable.getSubject();
    }

    @Override
    public List<Role> getRoles() {
        return this.authorizable.getRoles();
    }

    @Override
    public List<Permission> getPermissions() {
        return this.authorizable.getPermissions();
    }

    GrantedObject(Authenticable authenticable, Authorizable authorizable) {
        this.authenticable = authenticable;
        this.authorizable = authorizable;
    }

    public static GrantedObjectBuilder builder() {
        return new GrantedObjectBuilder();
    }

    public Authenticable getAuthenticable() {
        return this.authenticable;
    }

    public Authorizable getAuthorizable() {
        return this.authorizable;
    }

    public static class GrantedObjectBuilder {
        private Authenticable authenticable;
        private Authorizable authorizable;

        GrantedObjectBuilder() {
        }

        public GrantedObjectBuilder authenticable(Authenticable authenticable) {
            this.authenticable = authenticable;
            return this;
        }

        public GrantedObjectBuilder authorizable(Authorizable authorizable) {
            this.authorizable = authorizable;
            return this;
        }

        public GrantedObject build() {
            return new GrantedObject(this.authenticable, this.authorizable);
        }

        public String toString() {
            return "GrantedObject.GrantedObjectBuilder(authenticable=" + this.authenticable + ", authorizable=" + this.authorizable + ")";
        }
    }
}

