/*
 * Decompiled with CFR 0.152.
 */
package co.abit.prime.domain;

import co.abit.prime.domain.Authorizable;
import co.abit.prime.domain.Permission;
import co.abit.prime.domain.Role;
import java.util.List;

class AuthorizedObject
implements Authorizable {
    private List<Role> roles;
    private List<Permission> permissions;

    AuthorizedObject(List<Role> roles, List<Permission> permissions) {
        this.roles = roles;
        this.permissions = permissions;
    }

    public static AuthorizedObjectBuilder builder() {
        return new AuthorizedObjectBuilder();
    }

    @Override
    public List<Role> getRoles() {
        return this.roles;
    }

    @Override
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public static class AuthorizedObjectBuilder {
        private List<Role> roles;
        private List<Permission> permissions;

        AuthorizedObjectBuilder() {
        }

        public AuthorizedObjectBuilder roles(List<Role> roles) {
            this.roles = roles;
            return this;
        }

        public AuthorizedObjectBuilder permissions(List<Permission> permissions) {
            this.permissions = permissions;
            return this;
        }

        public AuthorizedObject build() {
            return new AuthorizedObject(this.roles, this.permissions);
        }

        public String toString() {
            return "AuthorizedObject.AuthorizedObjectBuilder(roles=" + this.roles + ", permissions=" + this.permissions + ")";
        }
    }
}

