/*
 * Decompiled with CFR 0.152.
 */
package co.abit.prime.domain;

import co.abit.prime.domain.AuthorizedObject;
import co.abit.prime.domain.Permission;
import co.abit.prime.domain.Role;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface Authorizable {
    public List<Role> getRoles();

    public List<Permission> getPermissions();

    default public boolean has(Role ... roles) {
        for (Role role : roles) {
            if (!this.getRoles().contains(role)) continue;
            return true;
        }
        return false;
    }

    default public boolean has(Permission ... permissions) {
        for (Permission permission : permissions) {
            if (!this.getPermissions().contains(permission)) continue;
            return true;
        }
        return false;
    }

    public static Authorizable from(Role ... roles) {
        return Authorizable.from(Arrays.asList(roles), new ArrayList<Permission>());
    }

    public static Authorizable from(Permission ... permissions) {
        return Authorizable.from(new ArrayList<Role>(), Arrays.asList(permissions));
    }

    public static Authorizable from(List<Role> roles, List<Permission> permissions) {
        return AuthorizedObject.builder().roles(roles).permissions(permissions).build();
    }
}

