/*
 * Decompiled with CFR 0.152.
 */
package co.abit.prime.domain;

import co.abit.prime.domain.Authenticable;

class AuthenticatedObject
implements Authenticable {
    private String id;
    private String subject;
    private String identifier;

    AuthenticatedObject(String id, String subject, String identifier) {
        this.id = id;
        this.subject = subject;
        this.identifier = identifier;
    }

    public static AuthenticatedObjectBuilder builder() {
        return new AuthenticatedObjectBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public static class AuthenticatedObjectBuilder {
        private String id;
        private String subject;
        private String identifier;

        AuthenticatedObjectBuilder() {
        }

        public AuthenticatedObjectBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AuthenticatedObjectBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public AuthenticatedObjectBuilder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public AuthenticatedObject build() {
            return new AuthenticatedObject(this.id, this.subject, this.identifier);
        }

        public String toString() {
            return "AuthenticatedObject.AuthenticatedObjectBuilder(id=" + this.id + ", subject=" + this.subject + ", identifier=" + this.identifier + ")";
        }
    }
}

