package co.abit.prime.dev;

import java.util.Iterator;

public interface TestOperator {
    /**
     * Runs before class' execution
     */
    default void setUp() {}

    /**
     * Runs after class' execution
     */
    default void tearDown() {}

    /**
     * Runs before method's execution
     */
    default void beforeEach() {}

    /**
     * Runs after method's execution
     */
    default void afterEach() {}

    /**
     * Registers an operator to global manager
     * @param operator an object represents for operator to be registered
     * @return true if success, false if otherwise
     */
    static boolean register(TestOperator operator) {
        return PrimeTestOperator.operators.add(operator);
    }

    /**
     * Removes an operator from global manager
     * @param index an integer represents for index of operator
     * @return a removed operator object
     */
    static TestOperator remove(int index) {
        return PrimeTestOperator.operators.remove(index);
    }

    /**
     * Returns global manager's iterator
     * @return an iterator of global manager
     */
    static Iterator<TestOperator> iterator() {
        return PrimeTestOperator.operators.iterator();
    }
}
