package co.abit.prime.client.http.response;

import co.abit.prime.client.response.ErrorResponseBody;
import co.abit.prime.client.response.ResponseAvailable;

import java.util.Optional;
import java.util.Set;

public interface ApiResponse<T> extends ResponseAvailable {
    /**
     * Get response's status
     * @return an optional of status
     */
    Optional<ResponseStatus> getStatus();

    /**
     * Get response's headers
     * @return an optional of headers
     */
    Optional<ResponseHeaders> getHeaders();

    /**
     * Returns response's body
     * @return an object represents for body
     */
    Optional<T> getBody();

    /**
     * Return a list of errors
     * @return a list
     */
    Set<ErrorResponseBody> getErrors();

    /**
     * Returns first error
     * @return ErrorResponseBody
     */
    default Optional<ErrorResponseBody> getError() {
        Set<ErrorResponseBody> errors = getErrors();
        return errors.size() > 0 ? errors.stream().findAny() : Optional.empty();
    }
}
