package co.abit.prime.client.http;

import co.abit.prime.client.http.response.ApiResponse;
import co.abit.prime.client.response.ResponseBody;

import static co.abit.prime.client.http.HttpMethod.*;

public interface PrimeHttpClient extends HttpClient {
    default <T> ApiResponse<T> get(String uri, Class<? extends ResponseBody> responseBodyClass) {
        return call(GET, uri, responseBodyClass);
    }

    default <T> ApiResponse<T> post(String uri, Object body, Class<? extends ResponseBody> responseBodyClass) {
        return call(POST, uri, responseBodyClass, body);
    }

    default <T> ApiResponse<T> patch(String uri, Object body, Class<? extends ResponseBody> responseBodyClass) {
        return call(PUT, uri, responseBodyClass, body);
    }

    default <T> ApiResponse<T> put(String uri, Object body, Class<? extends ResponseBody> responseBodyClass) {
        return call(PATCH, uri, responseBodyClass, body);
    }

    default void delete(String uri) {
        call(DELETE, uri, null);
    }
}
