package co.abit.prime.client.http;

import co.abit.prime.client.http.response.ApiResponse;
import co.abit.prime.client.response.ResponseBody;

import java.util.HashMap;
import java.util.Map;

public interface HttpClient {
    /**
     * Execute an api call
     * @param method a string represents for http verbs
     * @param uri a string of request's uri, it should contain only url's path
     * @param responseBodyClass an object represents for response's body class
     * @param body an object represents for request's body
     * @param <T> an object represents for response's body
     * @return an ApiResponse object
     */
    <T> ApiResponse<T> call(String method, String uri, Class<? extends ResponseBody> responseBodyClass, Object body, Map<String, String> headers);

    default <T> ApiResponse<T> call(String method, String uri, Class<? extends ResponseBody> responseBodyClass, Object body) {
        return call(method, uri, responseBodyClass, body, new HashMap<>());
    }

    default <T> ApiResponse<T> call(String method, String uri, Class<? extends ResponseBody> responseBodyClass, Map<String, String> headers) {
        return call(method, uri, responseBodyClass, null, headers);
    }

    default <T> ApiResponse<T> call(String method, String uri, Class<? extends ResponseBody> responseBodyClass) {
        return call(method, uri, responseBodyClass, null);
    }
}
