package co.abit.prime.cache;

public interface CacheHandler {
    /**
     * Returns a cache item by key
     * @param key a string represents for cache's key
     * @return an instance of CacheItem
     */
    CacheItem get(String key);

    /**
     * Puts one or more items into cache
     *
     * @param items an array of items to be put into cache
     * @return an integer represents for number of items are successfully put into cache
     */
    int put(CacheItem... items);

    /**
     * Deletes one ore more keys from cache
     *
     * @param keys an array of keys to be deleted from cache
     * @return an integer represents for number of items are successfully deleted from cache
     */
    int delete(String... keys);

    /**
     * Determines whether or not a key exists in cache
     * @param key a string represents for cache's key
     * @return true if exists, and false on otherwise
     */
    default Boolean has(String key) {
        return get(key).getValue() != null;
    }
}