package co.abit.prime.cache.redis;

import co.abit.prime.cache.CacheItem;

import java.util.List;

public interface ListCacheHandler {
    /**
     * Push item to the left
     * @param key a string represents for key
     * @param values a number of object as values
     * @return a long number represents for number items are added
     */
    long pushLeft(String key, Object... values);

    /**
     * Push item to the right
     * @param key a string represents for key
     * @param values a number of object as values
     * @return a long number represents for number items are added
     */
    long pushRight(String key, Object... values);

    /**
     * Pop item from the left
     * @param key a string represents for key
     * @return an object represents for CacheItem
     */
    CacheItem popLeft(String key);

    /**
     * Pop item from the right
     * @param key a string represents for key
     * @return an object represents for CacheItem
     */
    CacheItem popRight(String key);

    /**
     * Get a number of item from list
     * @param key a string represents for cache's key
     * @param start a long number specifies start position
     * @param stop a long number specifies stop position
     * @return a list of objects represents for CacheItem
     */
    List<CacheItem> range(String key, long start, long stop);

    /**
     * Get number of elements in cache
     * @param key a string represents for cache's key
     * @return a long number represents for number of items
     */
    long size(String key);
}
