/*
 * Decompiled with CFR 0.152.
 */
package co.abit.ares.cache.redis.config;

import co.abit.ares.cache.redis.RedisListCacheHandler;
import co.abit.ares.cache.redis.config.RedisProperties;
import co.abit.prime.cache.redis.ListCacheHandler;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedisBeanConfig {
    private RedisProperties properties;

    @Autowired
    public RedisBeanConfig(RedisProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisClient redisClient() {
        RedisClient client = RedisClient.create((RedisURI)RedisURI.create((String)this.properties.getHost(), (int)this.properties.getPort()));
        client.setDefaultTimeout(Duration.ofSeconds(20L));
        return client;
    }

    @Bean
    @ConditionalOnMissingBean
    public ListCacheHandler listCacheHandler() {
        return new RedisListCacheHandler(this.redisClient());
    }
}

