/*
 * Decompiled with CFR 0.152.
 */
package co.abit.ares.aws.dynamodb.service;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DynamoDBService {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDBService.class);
    private AmazonDynamoDB amazonDynamoDB;

    @Autowired
    public DynamoDBService(AmazonDynamoDB amazonDynamoDB) {
        this.amazonDynamoDB = amazonDynamoDB;
    }

    private DynamoDB getDynamoDB() {
        return new DynamoDB(this.amazonDynamoDB);
    }

    public List<Table> listTables() {
        ArrayList<Table> tables = new ArrayList<Table>();
        this.getDynamoDB().listTables().forEach(tables::add);
        return tables;
    }

    public void deleteTable(String tableName) {
        Table table = this.getDynamoDB().getTable(tableName);
        try {
            table.delete();
            table.waitForDelete();
        }
        catch (ResourceNotFoundException | InterruptedException e) {
            logger.warn("Unable to delete table {}. Exception: {}", (Object)tableName, (Object)e.getMessage());
        }
    }

    public void createTable(CreateTableRequest request) {
        try {
            this.getDynamoDB().createTable(request);
        }
        catch (Exception e) {
            logger.error("Unable to create table {}. Exception: {}", (Object)request.getTableName(), (Object)e.getMessage());
        }
    }
}

