/*
 * Decompiled with CFR 0.152.
 */
package co.abit.ares.aws.dynamodb.config;

import co.abit.ares.aws.core.config.AWSProperties;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsyncClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AWSDynamoDbBeanConfig {
    private AWSProperties properties;
    private AWSCredentialsProvider awsCredentialsProvider;

    @Autowired
    public AWSDynamoDbBeanConfig(AWSProperties properties, AWSCredentialsProvider awsCredentialsProvider) {
        this.properties = properties;
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public AmazonDynamoDB amazonDynamoDB() {
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials(this.awsCredentialsProvider)).withEndpointConfiguration(this.getDynamoDBEndpointConfiguration())).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public AmazonDynamoDBAsync amazonDynamoDBAsync() {
        return (AmazonDynamoDBAsync)((AmazonDynamoDBAsyncClientBuilder)((AmazonDynamoDBAsyncClientBuilder)AmazonDynamoDBAsyncClientBuilder.standard().withCredentials(this.awsCredentialsProvider)).withEndpointConfiguration(this.getDynamoDBEndpointConfiguration())).build();
    }

    private AwsClientBuilder.EndpointConfiguration getDynamoDBEndpointConfiguration() {
        String dynamoDBEndpoint = this.properties.getDynamodbEndpoint();
        if (dynamoDBEndpoint.isEmpty()) {
            return new AwsClientBuilder.EndpointConfiguration(null, this.properties.getRegion());
        }
        return new AwsClientBuilder.EndpointConfiguration(dynamoDBEndpoint, this.properties.getRegion());
    }
}

