package co.abit.ares.aws.dynamodb.service;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class DynamoDBService {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDBService.class);
    private AmazonDynamoDB amazonDynamoDB;

    @Autowired
    public DynamoDBService(AmazonDynamoDB amazonDynamoDB) {
        this.amazonDynamoDB = amazonDynamoDB;
    }

    private DynamoDB getDynamoDB() {
        return new DynamoDB(amazonDynamoDB);
    }

    public List<Table> listTables() {
        List<Table> tables = new ArrayList<>();
        getDynamoDB().listTables().forEach(tables::add);

        return tables;
    }

    public void deleteTable(String tableName) {
        Table table = getDynamoDB().getTable(tableName);
        try {
            table.delete();
            table.waitForDelete();
        } catch (ResourceNotFoundException | InterruptedException e) {
            logger.warn("Unable to delete table {}. Exception: {}", tableName, e.getMessage());
        }
    }

    public void createTable(CreateTableRequest request) {
        try {
            getDynamoDB().createTable(request);
        } catch (Exception e) {
            logger.error("Unable to create table {}. Exception: {}", request.getTableName(), e.getMessage());
        }
    }

}
